<?php
// CRITICAL: Must be at the very top before any output
@ini_set('display_errors', '0');
@ini_set('display_startup_errors', '0');
@error_reporting(0);

// Suppress all errors and warnings
set_error_handler(function() { return true; });

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

require_once '../config/database.php';

try {
    $db = Database::getInstance()->getConnection();
} catch(Exception $e) {
    echo json_encode(array(
        'success' => false,
        'message' => 'Database connection failed'
    ));
    exit;
}

$action = isset($_GET['action']) ? $_GET['action'] : '';

function getMultiAccountOverview($db) {
    $sql = "SELECT 
        a.id,
        a.account_name,
        a.account_code,
        am.service_level,
        am.service_level_target,
        am.asa,
        am.asa_target,
        am.aht,
        am.aht_target,
        am.abandon_rate,
        am.abandon_target,
        am.agents_online,
        am.agents_scheduled,
        am.occupancy,
        am.occupancy_target,
        am.csat_score,
        am.csat_target,
        am.qa_compliance,
        am.qa_target
    FROM accounts a
    LEFT JOIN account_metrics am ON a.id = am.account_id
    ORDER BY a.account_name";
    
    $stmt = $db->prepare($sql);
    $stmt->execute();
    return $stmt->fetchAll();
}



function getMultiAccountOverviewAPI_1($db) {
    // 1. Force PDO to show errors (Essential for debugging)
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $sql = "SELECT vendor_id, vendor_name FROM vendors WHERE deleted = 0 AND vendor_id=100 ORDER BY vendor_name";
    $stmt = $db->prepare($sql);
    $stmt->execute();

    $currentDate = date('Y-m-d');  

    // Note: I included 'report_date' - ensure this column exists in your table!
    $upsertSql = "INSERT INTO vendor_metrics 
                  (vendor_id, report_date, service_level, service_level_target, asa, asa_target, aht, aht_target,
                  abandon_rate, abandon_target, agents_online, agents_scheduled, occupancy, occupancy_target,
                  csat_score, csat_target, qa_compliance, qa_target)               
                  VALUES (:v_id, :r_date, :sla, :sla_target, :asa, :asa_target, :aht, :aht_target, 
                        :abandon_rate, :abandon_target, :agents_online, :agents_scheduled, :occupancy, :occupancy_target,
                        :csat_score, :csat_target, :qa_compliance, :qa_target)
                  ON DUPLICATE KEY UPDATE 
                    service_level = VALUES(service_level),
                    asa = VALUES(asa),
                    aht = VALUES(aht),
                    abandon_rate = VALUES(abandon_rate)";
    
    $upsertStmt = $db->prepare($upsertSql);

   
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $vendorId = $row['vendor_id'];

        $curl = curl_init();
        $postData = json_encode(["vendor_id" => (int)$vendorId, "date" => $currentDate]);

        curl_setopt_array($curl, array(
            CURLOPT_URL => 'http://172.20.60.110:5005/get_stats',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true, // Simplified POST
            CURLOPT_POSTFIELDS => $postData,
            CURLOPT_HTTPHEADER => array('Content-Type: application/json'),
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST'
        ));

        $response = curl_exec($curl);
        
        if (curl_errno($curl)) {
            die("CURL Error: " . curl_error($curl)); // Check if server can reach the IP
        }
        curl_close($curl);

        $data = json_decode($response, true);

        if (isset($data['total'])) {
            $total = $data['total'];                

            try {
                $upsertStmt->execute([
                    ':v_id'             => $vendorId,
                    ':r_date'           => $currentDate, 
                    ':sla'              => $total['SLA'],
                    ':sla_target'       => 85,
                    ':asa'              => $total['AvgSpeedofAnswer'],
                    ':asa_target'       => 30,
                    ':aht'              => $total['AvgHandlingTime'],
                    ':aht_target'       => 600,
                    ':abandon_rate'     => $total['Abnrate'],
                    ':abandon_target'   => 5,
                    ':agents_online'    => 48,
                    ':agents_scheduled' => 50,
                    ':occupancy'        => 88,
                    ':occupancy_target' => 80,
                    ':csat_score'       => 4.8,
                    ':csat_target'      => 4.5,
                    ':qa_compliance'    => 98,
                    ':qa_target'        => 90
                ]);
            } catch (PDOException $e) {
                // This will stop the script and tell you EXACTLY which column is the problem
                die("Database Error: " . $e->getMessage()); 
            }
        } else {
            // Debug: If total isn't set, show the API response
            die("API returned success but no 'total' key found. Response: " . $response);
        }
    }

    // Final Data Return
    $query = "SELECT 
                v.vendor_id account_id, v.vendor_name account_name,
                vm.service_level, vm.service_level_target, vm.asa, vm.asa_target,
                vm.aht, vm.aht_target, vm.abandon_rate, vm.abandon_target,
                vm.agents_online, vm.agents_scheduled, vm.occupancy, vm.occupancy_target,
                vm.csat_score, vm.csat_target, vm.qa_compliance, vm.qa_target
            FROM vendors v
            LEFT JOIN vendor_metrics vm ON v.vendor_id = vm.vendor_id AND vm.report_date = :current_date
            WHERE v.deleted = 0
            ORDER BY v.vendor_name";
    
    $stmt = $db->prepare($query);
    $stmt->execute([':current_date' => $currentDate]);
    return $stmt->fetchAll();
}


//1.28.2026 Franz: Added endpoint to get stats for all accounts
function getMultiAccountOverviewAPI() {

    //$curr_date = date('Y-m-d');
   // $curr_date = date('Y-m-d', strtotime('yesterday'));
        
    $curl = curl_init();

    curl_setopt_array($curl, array(
    CURLOPT_URL => 'http://173.255.5.94:5005/get_all_stats',
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => '',
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 0,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => 'GET',
    ));

    $response = curl_exec($curl);

    $arr_data = json_decode($response, true);
    //$output['queues'] = array();      

    //get queues data
    if (is_array($arr_data) && array_key_exists('consolidated_stats', $arr_data))
    {
        if (is_array($arr_data['consolidated_stats']) && count($arr_data['consolidated_stats']) > 0)
        {
            $arr_metrics = array();
            foreach ($arr_data['consolidated_stats'] as $stats)
            {
                $arr_metric = array();

                $arr_metric['account_name'] = $stats['account_name'];
                $arr_metric['service_level'] = $stats['SLA'];
                
              
                $arr_metric['asa'] = timeToSeconds($stats['AvgSpeedofAnswer']);
                $arr_metric['aht'] = timeToSeconds($stats['AvgHandlingTime']);
                $arr_metric['abandon_rate'] = $stats['Abnrate'];
                $arr_metric['occupancy'] = 88;
                $arr_metric['csat_score'] = 4.8;        
                $arr_metric['agents_online'] = 48;
                $arr_metric['agents_scheduled'] = 50;
                $arr_metric['qa_compliance'] = 98;   

                $arr_metric['service_level_target'] = 85;
                $arr_metric['asa_target'] = 32;
                $arr_metric['aht_target'] = 600;
                $arr_metric['abandon_target'] = 5;
                $arr_metric['occupancy'] = 80;
                $arr_metric['csat_target'] = 4.5;   
                $arr_metric['qa_target'] = 90;                  

                array_push($arr_metrics, $arr_metric);
            }          

        }
    }       

    //$output['queues'] = $arr_queues;
    //return json_decode($records, true);
    return $arr_metrics;
    curl_close($curl);
    exit;
}


function getAccountDetails($db, $accountId) {
    
    // Get account metrics
    /*
    $sql = "SELECT 
        a.account_name,
        a.account_code,
        am.*
    FROM accounts a
    LEFT JOIN account_metrics am ON a.id = am.account_id
    WHERE a.id = :account_id";
    
    $stmt = $db->prepare($sql);
    $stmt->bindParam(':account_id', $accountId, PDO::PARAM_INT);
    $stmt->execute();
    $metrics = $stmt->fetch();
    */

    $arr_metrics = getAccountMetricsAPI($accountId);
    
    // Get agents
    $sql = "SELECT * FROM agents WHERE account_id = :account_id ORDER BY status, agent_name";
    $stmt = $db->prepare($sql);
    $stmt->bindParam(':account_id', $accountId, PDO::PARAM_INT);
    $stmt->execute();
    $agents = $stmt->fetchAll();
    
    // Get queues
   /*
    $sql = "SELECT * FROM queues WHERE account_id = :account_id ORDER BY calls_in_queue DESC";
    $stmt = $db->prepare($sql);
    $stmt->bindParam(':account_id', $accountId, PDO::PARAM_INT);
    $stmt->execute();
    $queues = $stmt->fetchAll();
    
    return array(
        'metrics' => $metrics,
        'agents' => $agents,
        'queues' => $queues
    );
    */

    $arr_queues = getAccountDetailsAPI($accountId);    
    
    $arr_data = array(
        //'metrics' => $metrics,
        'agents' => $agents       
    );

    $arr_output = array_merge($arr_data, $arr_queues, $arr_metrics);

    return $arr_output;


}


//1.20.2026 Franz: Added endpoint to get calls waiting from API specific per Account (accountId)
function getAccountDetailsAPI($accountId) {
        
    $curl = curl_init();

    curl_setopt_array($curl, array(
    CURLOPT_URL => 'http://173.255.5.94:5015/api/callwaiting?accountid='.$accountId,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => '',
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 0,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => 'GET',
    ));

    $response = curl_exec($curl);

    $arr_data = json_decode($response, true);
    $records = $output['queues'] = array();
    
    if (count($arr_data['queues']) > 0)
    {
        foreach($arr_data['queues'] as $queue)
        {
            $record = array();
            //$record['account_name'] = $queue['account_name'];
            $record['queue_name'] = $queue['queue_name'];
            $record['calls_in_queue'] = $queue['calls_waiting'];
            $record['wait_time'] = $queue['longest_wait_seconds'];

            $status_indicator = "red";
            if ($queue['longest_wait_seconds'] < 160)
                $status_indicator = "green";
            elseif ($queue['longest_wait_seconds'] >= 160 && $queue['longest_wait_seconds'] <= 300)
                $status_indicator = "yellow";

            $record['status_indicator'] = $status_indicator;

            array_push($records, $record);
        }
    }

    $output['queues'] = $records;

    //return json_decode($records, true);
    return $output;
    curl_close($curl);
    exit;
}



function timeToSeconds($timeData) {

    list($hours, $minutes, $seconds) = explode(':', $timeData);
    $totalSeconds = ($hours * 3600) + ($minutes * 60) + $seconds;
    return $totalSeconds;
}

//1.20.2026 Franz: Added endpoint to get calls waiting from API specific per Account (accountId)
function getAccountMetricsAPI($accountId) {

    //$curr_date = date('Y-m-d');
    $curr_date = date('Y-m-d', strtotime('yesterday'));
        
    $curl = curl_init();

    curl_setopt_array($curl, array(
    CURLOPT_URL => 'http://173.255.5.94:5005/get_stats?account_id='.$accountId.'&date='.$curr_date,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => '',
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 0,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => 'GET',
    ));

    $response = curl_exec($curl);

    $arr_data = json_decode($response, true);
    $output['metrics'] = array();

    $arr_metrics['service_level'] = 0;
    $arr_metrics['asa'] = 0;
    $arr_metrics['aht'] = 0;
    $arr_metrics['abandon_rate'] = 0;
    $arr_metrics['occupancy'] = 0;
    $arr_metrics['csat_score'] = 0;       
    $arr_metrics['agents_online'] = 0;
    $arr_metrics['agents_scheduled'] = 0;
    $arr_metrics['qa_compliance'] = 0;

    $arr_metrics['service_level_target'] = 85;
    $arr_metrics['asa_target'] = 32;
    $arr_metrics['aht_target'] = 600;
    $arr_metrics['abandon_target'] = 5;
    $arr_metrics['occupancy'] = 80;
    $arr_metrics['csat_target'] = 4.5;   
    $arr_metrics['qa_target'] = 90; 
    
    if (is_array($arr_data) && array_key_exists('total', $arr_data))
    {
        if (is_array($arr_data['total']))
        {
            if (count($arr_data['total']) > 0)
            {
                $arr_metrics['service_level'] = $arr_data['total']['SLA'];
                $arr_metrics['asa'] = timeToSeconds($arr_data['total']['AvgSpeedofAnswer']);
                $arr_metrics['aht'] = timeToSeconds($arr_data['total']['AvgHandlingTime']);
                $arr_metrics['abandon_rate'] = $arr_data['total']['Abnrate'];
                $arr_metrics['occupancy'] = 88;
                $arr_metrics['csat_score'] = 4.8;        
                $arr_metrics['agents_online'] = 48;
                $arr_metrics['agents_scheduled'] = 50;
                $arr_metrics['qa_compliance'] = 98;         
            }
        }
        
    }
    

    $output['metrics'] = $arr_metrics;

    //return json_decode($records, true);
    return $output;
    curl_close($curl);
    exit;
}


function getAccounts($db) {
    $sql = "SELECT id, account_name, account_code FROM accounts ORDER BY account_name";
    $stmt = $db->prepare($sql);
    $stmt->execute();
    return $stmt->fetchAll();
}

//1.7.2026 Franz: Added endpoint to get accounts from API
function getAccountsAPI() {
    $output['error'] = 1;
    $output['data'] = 'No data found';

    $curl = curl_init();

    curl_setopt_array($curl, array(
    CURLOPT_URL => 'http://173.255.5.94:5016/api/accounts',
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => '',
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 0,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => 'GET',
    ));

    $response = curl_exec($curl);
    return json_decode($response, true);
    curl_close($curl);
    exit;
    
}

function getForecastData($db, $accountId) {
    $sql = "SELECT 
        TIME_FORMAT(time_slot, '%H:%i') as time_slot,
        forecast_calls,
        actual_calls
    FROM forecast_data
    WHERE account_id = :account_id 
    AND date_recorded = CURDATE()
    ORDER BY time_slot";
    
    $stmt = $db->prepare($sql);
    $stmt->bindParam(':account_id', $accountId, PDO::PARAM_INT);
    $stmt->execute();
    return $stmt->fetchAll();
}

function getSLATrend($db, $accountId) {
    $sql = "SELECT 
        TIME_FORMAT(time_slot, '%H:%i') as time_slot,
        sla_percentage,
        asa_seconds
    FROM sla_trend
    WHERE account_id = :account_id 
    AND date_recorded = CURDATE()
    ORDER BY time_slot";
    
    $stmt = $db->prepare($sql);
    $stmt->bindParam(':account_id', $accountId, PDO::PARAM_INT);
    $stmt->execute();
    return $stmt->fetchAll();
}

function getAgentLoginData($db, $accountId) {
    $sql = "SELECT 
        TIME_FORMAT(time_slot, '%H:%i') as time_slot,
        logged_in,
        available
    FROM agent_login_data
    WHERE account_id = :account_id 
    AND date_recorded = CURDATE()
    ORDER BY time_slot";
    
    $stmt = $db->prepare($sql);
    $stmt->bindParam(':account_id', $accountId, PDO::PARAM_INT);
    $stmt->execute();
    return $stmt->fetchAll();
}



//1.29.2026 Franz: Added endpoint to get 30mins interval data for Agent Logged in/Available from API specific per Account (accountId)
function getAgentLoginDataAPI($accountId) {

    //$curr_date = date('Y-m-d');
   // $curr_date = date('Y-m-d', strtotime('yesterday'));
        
    $curl = curl_init();

    curl_setopt_array($curl, array(
    CURLOPT_URL => 'http://173.255.5.94:5016/get_agent_count_history?account_id='.$accountId,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => '',
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 0,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => 'GET',
    ));

    $response = curl_exec($curl);

    $arr_data = json_decode($response, true);
    //$output['forecast'] = array();    

    //get queues data
    if (is_array($arr_data) && array_key_exists('intervals', $arr_data))
    {
        if (is_array($arr_data['intervals']) && count($arr_data['intervals']) > 0)
        {
            $arr_agents = array();           
            
            foreach ($arr_data['intervals'] as $time => $records) 
            {
                $arr_agent = array();    
                $arr_agent['time_slot'] = $time;
                $arr_agent['logged_in'] = $records[0]['total_logged_in'];
                $arr_agent['available'] = $records[0]['idle'];
                array_push($arr_agents, $arr_agent);

                // foreach ($records as $record) 
                // {               

                //     $arr_agent['logged_in'] = $record['total_logged_in'];
                //     $arr_agent['available'] = $record['idle'];
                
                //     array_push($arr_agents, $arr_agent);                    
                // }
            }

        }
    }  

    return $arr_agents;     
    curl_close($curl);
    exit;
}


function getTotalCallsInQueue($db) {
    $sql = "SELECT COALESCE(SUM(calls_in_queue), 0) as total FROM queues";
    $stmt = $db->prepare($sql);
    $stmt->execute();
    $result = $stmt->fetch();
    return intval($result['total']);
}

function getAllQueuesForMultiAccount($db) {
    $sql = "SELECT 
        a.account_code,
        q.queue_name,
        q.calls_in_queue,
        q.wait_time,
        q.status_indicator
    FROM queues q
    INNER JOIN accounts a ON q.account_id = a.id
    WHERE q.calls_in_queue > 0
    ORDER BY q.wait_time DESC
    LIMIT 10";
    
    $stmt = $db->prepare($sql);
    $stmt->execute();
    return $stmt->fetchAll();
}


//1.19.2026 Franz: Added endpoint to get calls waiting from API
function getAllQueuesForMultiAccountAPI() {
        
    $curl = curl_init();

    curl_setopt_array($curl, array(
    CURLOPT_URL => 'http://173.255.5.94:5015/api/callwaiting?accountid=9999',
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => '',
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 0,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => 'GET',
    ));

    $response = curl_exec($curl);

    $arr_data = json_decode($response, true);
    $records = array();
    
    if (count($arr_data['queues']) > 0)
    {
        foreach($arr_data['queues'] as $queue)
        {
            $record = array();
            $record['account_name'] = $queue['account_name'];
            $record['calls_in_queue'] = $queue['calls_waiting'];
            $record['wait_time'] = $queue['longest_wait_seconds'];

            $status_indicator = "red";
            if ($queue['longest_wait_seconds'] < 160)
                $status_indicator = "green";
            elseif ($queue['longest_wait_seconds'] >= 160 && $queue['longest_wait_seconds'] <= 300)
                $status_indicator = "yellow";

            $record['status_indicator'] = $status_indicator;

            array_push($records, $record);
        }
    }

    //return json_decode($records, true);
    return $records;
    curl_close($curl);
    exit;
}

function getQueuePerformanceDaily($db, $accountId) {
    $sql = "SELECT 
        queue_name,
        calls_in_queue as total_calls,
        FLOOR(calls_in_queue * 0.92) as handled_calls,
        wait_time as avg_wait_time,
        CASE 
            WHEN status_indicator = 'green' THEN FLOOR(85 + (RAND() * 10))
            WHEN status_indicator = 'yellow' THEN FLOOR(75 + (RAND() * 10))
            ELSE FLOOR(65 + (RAND() * 10))
        END as sla_percentage,
        status_indicator
    FROM queues
    WHERE account_id = :account_id
    ORDER BY calls_in_queue DESC";
    
    $stmt = $db->prepare($sql);
    $stmt->bindParam(':account_id', $accountId, PDO::PARAM_INT);
    $stmt->execute();
    return $stmt->fetchAll();
}


//1.26.2026 Franz: Added endpoint to get calls performance per queue from API specific per Account (accountId)
function getQueuePerformanceDailyAPI($accountId) {

    //$curr_date = date('Y-m-d');
    $curr_date = date('Y-m-d', strtotime('yesterday'));
        
    $curl = curl_init();

    curl_setopt_array($curl, array(
    CURLOPT_URL => 'http://173.255.5.94:5005/get_stats?account_id='.$accountId.'&date='.$curr_date,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => '',
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 0,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => 'GET',
    ));

    $response = curl_exec($curl);

    $arr_data = json_decode($response, true);
    $output['queues'] = array();    

    //get queues data
    if (is_array($arr_data) && array_key_exists('queues', $arr_data))
    {
        if (is_array($arr_data['queues']) && count($arr_data['queues']) > 0)
        {
            $arr_queues = array();
            foreach ($arr_data['queues'] as $queue)
            {
                $arr_queue = array();

                $arr_queue['queue_name'] = $queue['QueueName'];
                $arr_queue['total_calls'] = $queue['Offered'];
                $arr_queue['handled_calls'] = $queue['Handled'];
                $arr_queue['avg_wait_time'] = timeToSeconds($queue['AvgHandlingTime']);
                $arr_queue['sla_percentage'] = $queue['SLA'];
                array_push($arr_queues, $arr_queue);
            }          

        }
    }       

    $output['queues'] = $arr_queues;
    //return json_decode($records, true);
    return $output;
    curl_close($curl);
    exit;
}





//1.27.2026 Franz: Added endpoint to get 30mins interval data for Forecast from API specific per Account (accountId)
function getForecastDataAPI($accountId) {

    //$curr_date = date('Y-m-d');
    $curr_date = date('Y-m-d', strtotime('yesterday'));
        
    $curl = curl_init();

    curl_setopt_array($curl, array(
    CURLOPT_URL => 'http://173.255.5.94:5005/get_30min_stats?account_id='.$accountId.'&date='.$curr_date,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => '',
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 0,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => 'GET',
    ));

    $response = curl_exec($curl);

    $arr_data = json_decode($response, true);
    $output['forecast'] = array();    

    //get queues data
    if (is_array($arr_data) && array_key_exists('interval_stats', $arr_data))
    {
        if (is_array($arr_data['interval_stats']) && count($arr_data['interval_stats']) > 0)
        {
            $arr_forecasts = array();
            foreach ($arr_data['interval_stats'] as $forecast)
            {
                $arr_forecast = array();

                $arr_forecast['time_slot'] = $forecast['Interval'];
                $arr_forecast['forecast_calls'] = $forecast['Offered'];
                $arr_forecast['actual_calls'] = $forecast['Handled'];
               
                array_push($arr_forecasts, $arr_forecast);
            }          

        }
    }       

    //$output['forecast'] = $arr_forecasts;
    return $arr_forecasts;
    //return json_decode($records, true);   
    curl_close($curl);
    exit;
}



//1.27.2026 Franz: Added endpoint to get 30mins interval data from API for SLA trend specific per Account (accountId)
function getSLATrendAPI($accountId) {

    //$curr_date = date('Y-m-d');
    $curr_date = date('Y-m-d', strtotime('yesterday'));
        
    $curl = curl_init();

    curl_setopt_array($curl, array(
    CURLOPT_URL => 'http://173.255.5.94:5005/get_30min_stats?account_id='.$accountId.'&date='.$curr_date,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => '',
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 0,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => 'GET',
    ));

    $response = curl_exec($curl);

    $arr_data = json_decode($response, true);
    $output['slatrends'] = array();    

    //get queues data
    if (is_array($arr_data) && array_key_exists('interval_stats', $arr_data))
    {
        if (is_array($arr_data['interval_stats']) && count($arr_data['interval_stats']) > 0)
        {
            $arr_slatrends = array();
            foreach ($arr_data['interval_stats'] as $sla)
            {
                $arr_slatrend = array();

                $arr_slatrend['time_slot'] = $sla['Interval'];
                $arr_slatrend['sla_percentage'] = $sla['SLA'];
                $arr_slatrend['asa_seconds'] = timeToSeconds($sla['AvgSpeedofAnswer']);
               
                array_push($arr_slatrends, $arr_slatrend);
            }          

        }
    }       

    //$output['slatrends'] = $arr_slatrends;
    return $arr_slatrends;
    //return json_decode($records, true);   
    curl_close($curl);
    exit;
}



try {
    switch($action) {
        case 'multi_account_overview':
            $data = getMultiAccountOverviewAPI();
            //$data = getMultiAccountOverview($db);
            echo json_encode(array(
                'success' => true,
                'data' => $data
            ));
            break;
            
        case 'account_details':
            $accountId = isset($_GET['account_id']) ? intval($_GET['account_id']) : 1;
            $data = getAccountDetails($db, $accountId);            
            echo json_encode(array(
                'success' => true,
                'data' => $data
            ));
            break;

        case 'account_details_api':
            $accountId = isset($_GET['account_id']) ? intval($_GET['account_id']) : 1;           
            $data = getAccountDetailsAPI($accountId);
            echo json_encode(array(
                'success' => true,
                'data' => $data
            ));
            break;
            
        case 'accounts':
           // $data = getAccounts($db);
            $data = getAccountsAPI();
            echo json_encode(array(
                'success' => true,
                'data' => $data
            ));
            break;
            
        case 'forecast_data':
            $accountId = isset($_GET['account_id']) ? intval($_GET['account_id']) : 1;
            //$data = getForecastData($db, $accountId);
            $data = getForecastDataAPI($accountId);
            echo json_encode(array(
                'success' => true,
                'data' => $data
            ));
            break;
            
        case 'sla_trend':
            $accountId = isset($_GET['account_id']) ? intval($_GET['account_id']) : 1;
            //$data = getSLATrend($db, $accountId);
            $data = getSLATrendAPI($accountId);
            echo json_encode(array(
                'success' => true,
                'data' => $data
            ));
            break;
            
        case 'agent_login':
            $accountId = isset($_GET['account_id']) ? intval($_GET['account_id']) : 1;
            //$data = getAgentLoginData($db, $accountId);
            $data = getAgentLoginDataAPI($accountId);
            echo json_encode(array(
                'success' => true,
                'data' => $data
            ));
            break;
            
        case 'total_calls':
            $total = getTotalCallsInQueue($db);
            echo json_encode(array(
                'success' => true,
                'total' => $total
            ));
            break;
            
        case 'all_queues_multi':
            //$data = getAllQueuesForMultiAccount($db);
            $data = getAllQueuesForMultiAccountAPI();
            echo json_encode(array(
                'success' => true,
                'data' => $data
            ));
            break;
            
        case 'queue_performance_daily':
            $accountId = isset($_GET['account_id']) ? intval($_GET['account_id']) : 1;
            //$data = getQueuePerformanceDaily($db, $accountId);
            $data = getQueuePerformanceDailyAPI($accountId);
            echo json_encode(array(
                'success' => true,
                'data' => $data
            ));
            break;
            
        default:
            echo json_encode(array(
                'success' => false,
                'message' => 'Invalid action'
            ));
    }
} catch(Exception $e) {
    echo json_encode(array(
        'success' => false,
        'message' => 'An error occurred while processing your request'
    ));
}
?>