/*
MySQL Data Transfer
Source Host: localhost
Source Database: realtime_dashboard
Target Host: localhost
Target Database: realtime_dashboard
Date: 12/11/2025 3:26:01 pm
*/

SET FOREIGN_KEY_CHECKS=0;
-- ----------------------------
-- Table structure for account_metrics
-- ----------------------------
CREATE TABLE `account_metrics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_id` int(11) NOT NULL,
  `service_level` decimal(5,2) DEFAULT '0.00',
  `service_level_target` decimal(5,2) DEFAULT '85.00',
  `asa` int(11) DEFAULT '0',
  `asa_target` int(11) DEFAULT '30',
  `aht` int(11) DEFAULT '0',
  `aht_target` int(11) DEFAULT '600',
  `abandon_rate` decimal(5,2) DEFAULT '0.00',
  `abandon_target` decimal(5,2) DEFAULT '5.00',
  `agents_online` int(11) DEFAULT '0',
  `agents_scheduled` int(11) DEFAULT '0',
  `occupancy` decimal(5,2) DEFAULT '0.00',
  `occupancy_target` decimal(5,2) DEFAULT '80.00',
  `csat_score` decimal(3,2) DEFAULT '0.00',
  `csat_target` decimal(3,2) DEFAULT '4.50',
  `qa_compliance` decimal(5,2) DEFAULT '0.00',
  `qa_target` decimal(5,2) DEFAULT '90.00',
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_metrics_account` (`account_id`),
  CONSTRAINT `account_metrics_ibfk_1` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for accounts
-- ----------------------------
CREATE TABLE `accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_name` varchar(100) NOT NULL,
  `account_code` varchar(50) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `account_code` (`account_code`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for agent_login_data
-- ----------------------------
CREATE TABLE `agent_login_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_id` int(11) NOT NULL,
  `time_slot` time NOT NULL,
  `logged_in` int(11) DEFAULT '0',
  `available` int(11) DEFAULT '0',
  `date_recorded` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `idx_login_date` (`date_recorded`,`account_id`),
  CONSTRAINT `agent_login_data_ibfk_1` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=182 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for agents
-- ----------------------------
CREATE TABLE `agents` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `agent_id` varchar(50) NOT NULL,
  `agent_name` varchar(100) NOT NULL,
  `account_id` int(11) NOT NULL,
  `location` varchar(100) DEFAULT NULL,
  `desk_location` varchar(50) DEFAULT NULL,
  `status` enum('Active','Idle','Not Ready') DEFAULT 'Idle',
  `shift_duration` time DEFAULT NULL,
  `inbound_calls` int(11) DEFAULT '0',
  `outbound_calls` int(11) DEFAULT '0',
  `inbound_avg_time` int(11) DEFAULT '0',
  `outbound_avg_time` int(11) DEFAULT '0',
  `last_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `agent_id` (`agent_id`),
  KEY `idx_agents_status` (`status`),
  KEY `idx_agents_account` (`account_id`),
  CONSTRAINT `agents_ibfk_1` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=50 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for forecast_data
-- ----------------------------
CREATE TABLE `forecast_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_id` int(11) NOT NULL,
  `time_slot` time NOT NULL,
  `forecast_calls` int(11) DEFAULT '0',
  `actual_calls` int(11) DEFAULT '0',
  `date_recorded` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `idx_forecast_date` (`date_recorded`,`account_id`),
  CONSTRAINT `forecast_data_ibfk_1` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=182 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for queues
-- ----------------------------
CREATE TABLE `queues` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `queue_name` varchar(100) NOT NULL,
  `account_id` int(11) NOT NULL,
  `calls_in_queue` int(11) DEFAULT '0',
  `wait_time` int(11) DEFAULT '0',
  `status_indicator` enum('red','yellow','green') DEFAULT 'green',
  `last_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_queues_account` (`account_id`),
  CONSTRAINT `queues_ibfk_1` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sla_trend
-- ----------------------------
CREATE TABLE `sla_trend` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_id` int(11) NOT NULL,
  `time_slot` time NOT NULL,
  `sla_percentage` decimal(5,2) DEFAULT '0.00',
  `asa_seconds` int(11) DEFAULT '0',
  `date_recorded` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `idx_sla_date` (`date_recorded`,`account_id`),
  CONSTRAINT `sla_trend_ibfk_1` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=274 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records 
-- ----------------------------
INSERT INTO `account_metrics` VALUES ('1', '1', '90.30', '85.00', '28', '30', '550', '600', '3.10', '5.00', '48', '52', '84.00', '80.00', '4.60', '4.50', '91.00', '90.00', '2025-11-19 10:18:43');
INSERT INTO `account_metrics` VALUES ('2', '2', '85.50', '85.00', '43', '30', '661', '600', '5.10', '5.00', '35', '42', '81.00', '80.00', '4.30', '4.50', '87.00', '90.00', '2025-11-19 10:18:43');
INSERT INTO `account_metrics` VALUES ('3', '3', '92.40', '85.00', '26', '30', '542', '600', '2.30', '5.00', '62', '64', '86.00', '80.00', '4.70', '4.50', '93.00', '90.00', '2025-11-19 10:18:43');
INSERT INTO `account_metrics` VALUES ('4', '4', '80.50', '85.00', '56', '30', '782', '600', '7.20', '5.00', '28', '38', '79.00', '80.00', '4.10', '4.50', '82.00', '90.00', '2025-11-19 10:18:43');
INSERT INTO `account_metrics` VALUES ('5', '5', '88.70', '85.00', '35', '30', '590', '600', '2.30', '5.00', '44', '46', '88.00', '80.00', '4.50', '4.50', '90.00', '90.00', '2025-11-19 10:18:43');
INSERT INTO `account_metrics` VALUES ('6', '6', '85.90', '85.00', '39', '30', '583', '600', '4.60', '5.00', '31', '34', '76.00', '80.00', '4.40', '4.50', '88.00', '90.00', '2025-11-19 10:18:43');
INSERT INTO `accounts` VALUES ('1', 'SNA', 'SNA', '2025-11-11 09:22:50');
INSERT INTO `accounts` VALUES ('2', 'Cloud5', 'CLOUD5', '2025-11-11 09:22:50');
INSERT INTO `accounts` VALUES ('3', 'DeepBlue', 'DEEPBLUE', '2025-11-11 09:22:50');
INSERT INTO `accounts` VALUES ('4', 'BPRF', 'BPRF', '2025-11-11 09:22:50');
INSERT INTO `accounts` VALUES ('5', 'SageNet', 'SAGENET', '2025-11-11 09:22:50');
INSERT INTO `accounts` VALUES ('6', 'Bright', 'BRIGHT', '2025-11-11 09:22:50');
INSERT INTO `agent_login_data` VALUES ('1', '1', '08:00:00', '40', '38', '2025-11-11');
INSERT INTO `agent_login_data` VALUES ('2', '1', '08:30:00', '45', '35', '2025-11-11');
INSERT INTO `agent_login_data` VALUES ('3', '1', '09:00:00', '54', '38', '2025-11-11');
INSERT INTO `agent_login_data` VALUES ('4', '1', '09:30:00', '47', '37', '2025-11-11');
INSERT INTO `agent_login_data` VALUES ('5', '1', '10:00:00', '45', '39', '2025-11-11');
INSERT INTO `agent_login_data` VALUES ('6', '2', '08:00:00', '47', '38', '2025-11-11');
INSERT INTO `agent_login_data` VALUES ('7', '2', '08:30:00', '55', '44', '2025-11-11');
INSERT INTO `agent_login_data` VALUES ('8', '2', '09:00:00', '54', '41', '2025-11-11');
INSERT INTO `agent_login_data` VALUES ('9', '2', '09:30:00', '40', '37', '2025-11-11');
INSERT INTO `agent_login_data` VALUES ('10', '2', '10:00:00', '51', '39', '2025-11-11');
INSERT INTO `agent_login_data` VALUES ('11', '3', '08:00:00', '45', '37', '2025-11-11');
INSERT INTO `agent_login_data` VALUES ('12', '3', '08:30:00', '45', '48', '2025-11-11');
INSERT INTO `agent_login_data` VALUES ('13', '3', '09:00:00', '55', '44', '2025-11-11');
INSERT INTO `agent_login_data` VALUES ('14', '3', '09:30:00', '52', '47', '2025-11-11');
INSERT INTO `agent_login_data` VALUES ('15', '3', '10:00:00', '51', '46', '2025-11-11');
INSERT INTO `agent_login_data` VALUES ('16', '4', '08:00:00', '48', '37', '2025-11-11');
INSERT INTO `agent_login_data` VALUES ('17', '4', '08:30:00', '52', '40', '2025-11-11');
INSERT INTO `agent_login_data` VALUES ('18', '4', '09:00:00', '48', '44', '2025-11-11');
INSERT INTO `agent_login_data` VALUES ('19', '4', '09:30:00', '54', '49', '2025-11-11');
INSERT INTO `agent_login_data` VALUES ('20', '4', '10:00:00', '43', '37', '2025-11-11');
INSERT INTO `agent_login_data` VALUES ('21', '5', '08:00:00', '44', '38', '2025-11-11');
INSERT INTO `agent_login_data` VALUES ('22', '5', '08:30:00', '49', '41', '2025-11-11');
INSERT INTO `agent_login_data` VALUES ('23', '5', '09:00:00', '50', '45', '2025-11-11');
INSERT INTO `agent_login_data` VALUES ('24', '5', '09:30:00', '42', '43', '2025-11-11');
INSERT INTO `agent_login_data` VALUES ('25', '5', '10:00:00', '43', '50', '2025-11-11');
INSERT INTO `agent_login_data` VALUES ('26', '6', '08:00:00', '52', '35', '2025-11-11');
INSERT INTO `agent_login_data` VALUES ('27', '6', '08:30:00', '51', '43', '2025-11-11');
INSERT INTO `agent_login_data` VALUES ('28', '6', '09:00:00', '40', '35', '2025-11-11');
INSERT INTO `agent_login_data` VALUES ('29', '6', '09:30:00', '45', '39', '2025-11-11');
INSERT INTO `agent_login_data` VALUES ('30', '6', '10:00:00', '53', '37', '2025-11-11');
INSERT INTO `agent_login_data` VALUES ('31', '1', '08:00:00', '53', '36', '2025-11-19');
INSERT INTO `agent_login_data` VALUES ('32', '1', '08:30:00', '40', '41', '2025-11-19');
INSERT INTO `agent_login_data` VALUES ('33', '1', '09:00:00', '49', '37', '2025-11-19');
INSERT INTO `agent_login_data` VALUES ('34', '1', '09:30:00', '45', '35', '2025-11-19');
INSERT INTO `agent_login_data` VALUES ('35', '1', '10:00:00', '55', '46', '2025-11-19');
INSERT INTO `agent_login_data` VALUES ('36', '2', '08:00:00', '49', '45', '2025-11-19');
INSERT INTO `agent_login_data` VALUES ('37', '2', '08:30:00', '52', '46', '2025-11-19');
INSERT INTO `agent_login_data` VALUES ('38', '2', '09:00:00', '44', '35', '2025-11-19');
INSERT INTO `agent_login_data` VALUES ('39', '2', '09:30:00', '47', '44', '2025-11-19');
INSERT INTO `agent_login_data` VALUES ('40', '2', '10:00:00', '48', '40', '2025-11-19');
INSERT INTO `agent_login_data` VALUES ('41', '3', '08:00:00', '53', '41', '2025-11-19');
INSERT INTO `agent_login_data` VALUES ('42', '3', '08:30:00', '55', '39', '2025-11-19');
INSERT INTO `agent_login_data` VALUES ('43', '3', '09:00:00', '44', '43', '2025-11-19');
INSERT INTO `agent_login_data` VALUES ('44', '3', '09:30:00', '50', '37', '2025-11-19');
INSERT INTO `agent_login_data` VALUES ('45', '3', '10:00:00', '48', '49', '2025-11-19');
INSERT INTO `agent_login_data` VALUES ('46', '4', '08:00:00', '43', '45', '2025-11-19');
INSERT INTO `agent_login_data` VALUES ('47', '4', '08:30:00', '55', '37', '2025-11-19');
INSERT INTO `agent_login_data` VALUES ('48', '4', '09:00:00', '50', '49', '2025-11-19');
INSERT INTO `agent_login_data` VALUES ('49', '4', '09:30:00', '47', '36', '2025-11-19');
INSERT INTO `agent_login_data` VALUES ('50', '4', '10:00:00', '50', '47', '2025-11-19');
INSERT INTO `agent_login_data` VALUES ('51', '5', '08:00:00', '46', '38', '2025-11-19');
INSERT INTO `agent_login_data` VALUES ('52', '5', '08:30:00', '45', '41', '2025-11-19');
INSERT INTO `agent_login_data` VALUES ('53', '5', '09:00:00', '48', '44', '2025-11-19');
INSERT INTO `agent_login_data` VALUES ('54', '5', '09:30:00', '43', '42', '2025-11-19');
INSERT INTO `agent_login_data` VALUES ('55', '5', '10:00:00', '44', '44', '2025-11-19');
INSERT INTO `agent_login_data` VALUES ('56', '6', '08:00:00', '46', '39', '2025-11-19');
INSERT INTO `agent_login_data` VALUES ('57', '6', '08:30:00', '47', '38', '2025-11-19');
INSERT INTO `agent_login_data` VALUES ('58', '6', '09:00:00', '47', '42', '2025-11-19');
INSERT INTO `agent_login_data` VALUES ('59', '6', '09:30:00', '46', '50', '2025-11-19');
INSERT INTO `agent_login_data` VALUES ('60', '6', '10:00:00', '49', '40', '2025-11-19');
INSERT INTO `agent_login_data` VALUES ('61', '1', '08:00:00', '53', '36', '2025-11-24');
INSERT INTO `agent_login_data` VALUES ('62', '1', '08:30:00', '40', '41', '2025-11-24');
INSERT INTO `agent_login_data` VALUES ('63', '1', '09:00:00', '49', '37', '2025-11-24');
INSERT INTO `agent_login_data` VALUES ('64', '1', '09:30:00', '45', '35', '2025-11-24');
INSERT INTO `agent_login_data` VALUES ('65', '1', '10:00:00', '55', '46', '2025-11-24');
INSERT INTO `agent_login_data` VALUES ('66', '2', '08:00:00', '49', '45', '2025-11-24');
INSERT INTO `agent_login_data` VALUES ('67', '2', '08:30:00', '52', '46', '2025-11-24');
INSERT INTO `agent_login_data` VALUES ('68', '2', '09:00:00', '44', '35', '2025-11-24');
INSERT INTO `agent_login_data` VALUES ('69', '2', '09:30:00', '47', '44', '2025-11-24');
INSERT INTO `agent_login_data` VALUES ('70', '2', '10:00:00', '48', '40', '2025-11-24');
INSERT INTO `agent_login_data` VALUES ('71', '3', '08:00:00', '53', '41', '2025-11-24');
INSERT INTO `agent_login_data` VALUES ('72', '3', '08:30:00', '55', '39', '2025-11-24');
INSERT INTO `agent_login_data` VALUES ('73', '3', '09:00:00', '44', '43', '2025-11-24');
INSERT INTO `agent_login_data` VALUES ('74', '3', '09:30:00', '50', '37', '2025-11-24');
INSERT INTO `agent_login_data` VALUES ('75', '3', '10:00:00', '48', '49', '2025-11-24');
INSERT INTO `agent_login_data` VALUES ('76', '4', '08:00:00', '43', '45', '2025-11-24');
INSERT INTO `agent_login_data` VALUES ('77', '4', '08:30:00', '55', '37', '2025-11-24');
INSERT INTO `agent_login_data` VALUES ('78', '4', '09:00:00', '50', '49', '2025-11-24');
INSERT INTO `agent_login_data` VALUES ('79', '4', '09:30:00', '47', '36', '2025-11-24');
INSERT INTO `agent_login_data` VALUES ('80', '4', '10:00:00', '50', '47', '2025-11-24');
INSERT INTO `agent_login_data` VALUES ('81', '5', '08:00:00', '46', '38', '2025-11-24');
INSERT INTO `agent_login_data` VALUES ('82', '5', '08:30:00', '45', '41', '2025-11-24');
INSERT INTO `agent_login_data` VALUES ('83', '5', '09:00:00', '48', '44', '2025-11-24');
INSERT INTO `agent_login_data` VALUES ('84', '5', '09:30:00', '43', '42', '2025-11-24');
INSERT INTO `agent_login_data` VALUES ('85', '5', '10:00:00', '44', '44', '2025-11-24');
INSERT INTO `agent_login_data` VALUES ('86', '6', '08:00:00', '46', '39', '2025-11-24');
INSERT INTO `agent_login_data` VALUES ('87', '6', '08:30:00', '47', '38', '2025-11-24');
INSERT INTO `agent_login_data` VALUES ('88', '6', '09:00:00', '47', '42', '2025-11-24');
INSERT INTO `agent_login_data` VALUES ('89', '6', '09:30:00', '46', '50', '2025-11-24');
INSERT INTO `agent_login_data` VALUES ('90', '6', '10:00:00', '49', '40', '2025-11-24');
INSERT INTO `agent_login_data` VALUES ('91', '1', '08:00:00', '53', '36', '2025-12-01');
INSERT INTO `agent_login_data` VALUES ('92', '1', '08:30:00', '40', '41', '2025-12-01');
INSERT INTO `agent_login_data` VALUES ('93', '1', '09:00:00', '49', '37', '2025-12-01');
INSERT INTO `agent_login_data` VALUES ('94', '1', '09:30:00', '45', '35', '2025-12-01');
INSERT INTO `agent_login_data` VALUES ('95', '1', '10:00:00', '55', '46', '2025-12-01');
INSERT INTO `agent_login_data` VALUES ('96', '2', '08:00:00', '49', '45', '2025-12-01');
INSERT INTO `agent_login_data` VALUES ('97', '2', '08:30:00', '52', '46', '2025-12-01');
INSERT INTO `agent_login_data` VALUES ('98', '2', '09:00:00', '44', '35', '2025-12-01');
INSERT INTO `agent_login_data` VALUES ('99', '2', '09:30:00', '47', '44', '2025-12-01');
INSERT INTO `agent_login_data` VALUES ('100', '2', '10:00:00', '48', '40', '2025-12-01');
INSERT INTO `agent_login_data` VALUES ('101', '3', '08:00:00', '53', '41', '2025-12-01');
INSERT INTO `agent_login_data` VALUES ('102', '3', '08:30:00', '55', '39', '2025-12-01');
INSERT INTO `agent_login_data` VALUES ('103', '3', '09:00:00', '44', '43', '2025-12-01');
INSERT INTO `agent_login_data` VALUES ('104', '3', '09:30:00', '50', '37', '2025-12-01');
INSERT INTO `agent_login_data` VALUES ('105', '3', '10:00:00', '48', '49', '2025-12-01');
INSERT INTO `agent_login_data` VALUES ('106', '4', '08:00:00', '43', '45', '2025-12-01');
INSERT INTO `agent_login_data` VALUES ('107', '4', '08:30:00', '55', '37', '2025-12-01');
INSERT INTO `agent_login_data` VALUES ('108', '4', '09:00:00', '50', '49', '2025-12-01');
INSERT INTO `agent_login_data` VALUES ('109', '4', '09:30:00', '47', '36', '2025-12-01');
INSERT INTO `agent_login_data` VALUES ('110', '4', '10:00:00', '50', '47', '2025-12-01');
INSERT INTO `agent_login_data` VALUES ('111', '5', '08:00:00', '46', '38', '2025-12-01');
INSERT INTO `agent_login_data` VALUES ('112', '5', '08:30:00', '45', '41', '2025-12-01');
INSERT INTO `agent_login_data` VALUES ('113', '5', '09:00:00', '48', '44', '2025-12-01');
INSERT INTO `agent_login_data` VALUES ('114', '5', '09:30:00', '43', '42', '2025-12-01');
INSERT INTO `agent_login_data` VALUES ('115', '5', '10:00:00', '44', '44', '2025-12-01');
INSERT INTO `agent_login_data` VALUES ('116', '6', '08:00:00', '46', '39', '2025-12-01');
INSERT INTO `agent_login_data` VALUES ('117', '6', '08:30:00', '47', '38', '2025-12-01');
INSERT INTO `agent_login_data` VALUES ('118', '6', '09:00:00', '47', '42', '2025-12-01');
INSERT INTO `agent_login_data` VALUES ('119', '6', '09:30:00', '46', '50', '2025-12-01');
INSERT INTO `agent_login_data` VALUES ('120', '6', '10:00:00', '49', '40', '2025-12-01');
INSERT INTO `agent_login_data` VALUES ('121', '1', '08:00:00', '53', '36', '2025-12-02');
INSERT INTO `agent_login_data` VALUES ('122', '1', '08:30:00', '40', '41', '2025-12-02');
INSERT INTO `agent_login_data` VALUES ('123', '1', '09:00:00', '49', '37', '2025-12-02');
INSERT INTO `agent_login_data` VALUES ('124', '1', '09:30:00', '45', '35', '2025-12-02');
INSERT INTO `agent_login_data` VALUES ('125', '1', '10:00:00', '55', '46', '2025-12-02');
INSERT INTO `agent_login_data` VALUES ('126', '2', '08:00:00', '49', '45', '2025-12-02');
INSERT INTO `agent_login_data` VALUES ('127', '2', '08:30:00', '52', '46', '2025-12-02');
INSERT INTO `agent_login_data` VALUES ('128', '2', '09:00:00', '44', '35', '2025-12-02');
INSERT INTO `agent_login_data` VALUES ('129', '2', '09:30:00', '47', '44', '2025-12-02');
INSERT INTO `agent_login_data` VALUES ('130', '2', '10:00:00', '48', '40', '2025-12-02');
INSERT INTO `agent_login_data` VALUES ('131', '3', '08:00:00', '53', '41', '2025-12-02');
INSERT INTO `agent_login_data` VALUES ('132', '3', '08:30:00', '55', '39', '2025-12-02');
INSERT INTO `agent_login_data` VALUES ('133', '3', '09:00:00', '44', '43', '2025-12-02');
INSERT INTO `agent_login_data` VALUES ('134', '3', '09:30:00', '50', '37', '2025-12-02');
INSERT INTO `agent_login_data` VALUES ('135', '3', '10:00:00', '48', '49', '2025-12-02');
INSERT INTO `agent_login_data` VALUES ('136', '4', '08:00:00', '43', '45', '2025-12-02');
INSERT INTO `agent_login_data` VALUES ('137', '4', '08:30:00', '55', '37', '2025-12-02');
INSERT INTO `agent_login_data` VALUES ('138', '4', '09:00:00', '50', '49', '2025-12-02');
INSERT INTO `agent_login_data` VALUES ('139', '4', '09:30:00', '47', '36', '2025-12-02');
INSERT INTO `agent_login_data` VALUES ('140', '4', '10:00:00', '50', '47', '2025-12-02');
INSERT INTO `agent_login_data` VALUES ('141', '5', '08:00:00', '46', '38', '2025-12-02');
INSERT INTO `agent_login_data` VALUES ('142', '5', '08:30:00', '45', '41', '2025-12-02');
INSERT INTO `agent_login_data` VALUES ('143', '5', '09:00:00', '48', '44', '2025-12-02');
INSERT INTO `agent_login_data` VALUES ('144', '5', '09:30:00', '43', '42', '2025-12-02');
INSERT INTO `agent_login_data` VALUES ('145', '5', '10:00:00', '44', '44', '2025-12-02');
INSERT INTO `agent_login_data` VALUES ('146', '6', '08:00:00', '46', '39', '2025-12-02');
INSERT INTO `agent_login_data` VALUES ('147', '6', '08:30:00', '47', '38', '2025-12-02');
INSERT INTO `agent_login_data` VALUES ('148', '6', '09:00:00', '47', '42', '2025-12-02');
INSERT INTO `agent_login_data` VALUES ('149', '6', '09:30:00', '46', '50', '2025-12-02');
INSERT INTO `agent_login_data` VALUES ('150', '6', '10:00:00', '49', '40', '2025-12-02');
INSERT INTO `agent_login_data` VALUES ('151', '1', '08:00:00', '53', '36', '2025-12-11');
INSERT INTO `agent_login_data` VALUES ('152', '1', '08:30:00', '40', '41', '2025-12-11');
INSERT INTO `agent_login_data` VALUES ('153', '1', '09:00:00', '49', '37', '2025-12-11');
INSERT INTO `agent_login_data` VALUES ('154', '1', '09:30:00', '45', '35', '2025-12-11');
INSERT INTO `agent_login_data` VALUES ('155', '1', '10:00:00', '55', '46', '2025-12-11');
INSERT INTO `agent_login_data` VALUES ('156', '2', '08:00:00', '49', '45', '2025-12-11');
INSERT INTO `agent_login_data` VALUES ('157', '2', '08:30:00', '52', '46', '2025-12-11');
INSERT INTO `agent_login_data` VALUES ('158', '2', '09:00:00', '44', '35', '2025-12-11');
INSERT INTO `agent_login_data` VALUES ('159', '2', '09:30:00', '47', '44', '2025-12-11');
INSERT INTO `agent_login_data` VALUES ('160', '2', '10:00:00', '48', '40', '2025-12-11');
INSERT INTO `agent_login_data` VALUES ('161', '3', '08:00:00', '53', '41', '2025-12-11');
INSERT INTO `agent_login_data` VALUES ('162', '3', '08:30:00', '55', '39', '2025-12-11');
INSERT INTO `agent_login_data` VALUES ('163', '3', '09:00:00', '44', '43', '2025-12-11');
INSERT INTO `agent_login_data` VALUES ('164', '3', '09:30:00', '50', '37', '2025-12-11');
INSERT INTO `agent_login_data` VALUES ('165', '3', '10:00:00', '48', '49', '2025-12-11');
INSERT INTO `agent_login_data` VALUES ('166', '4', '08:00:00', '43', '45', '2025-12-11');
INSERT INTO `agent_login_data` VALUES ('167', '4', '08:30:00', '55', '37', '2025-12-11');
INSERT INTO `agent_login_data` VALUES ('168', '4', '09:00:00', '50', '49', '2025-12-11');
INSERT INTO `agent_login_data` VALUES ('169', '4', '09:30:00', '47', '36', '2025-12-11');
INSERT INTO `agent_login_data` VALUES ('170', '4', '10:00:00', '50', '47', '2025-12-11');
INSERT INTO `agent_login_data` VALUES ('171', '5', '08:00:00', '46', '38', '2025-12-11');
INSERT INTO `agent_login_data` VALUES ('172', '5', '08:30:00', '45', '41', '2025-12-11');
INSERT INTO `agent_login_data` VALUES ('173', '5', '09:00:00', '48', '44', '2025-12-11');
INSERT INTO `agent_login_data` VALUES ('174', '5', '09:30:00', '43', '42', '2025-12-11');
INSERT INTO `agent_login_data` VALUES ('175', '5', '10:00:00', '44', '44', '2025-12-11');
INSERT INTO `agent_login_data` VALUES ('176', '6', '08:00:00', '46', '39', '2025-12-11');
INSERT INTO `agent_login_data` VALUES ('177', '6', '08:30:00', '47', '38', '2025-12-11');
INSERT INTO `agent_login_data` VALUES ('178', '6', '09:00:00', '47', '42', '2025-12-11');
INSERT INTO `agent_login_data` VALUES ('179', '6', '09:30:00', '46', '50', '2025-12-11');
INSERT INTO `agent_login_data` VALUES ('180', '6', '10:00:00', '49', '40', '2025-12-11');
INSERT INTO `agents` VALUES ('1', 'AG-1042', 'Sarah Mitchell', '1', 'Onsite', 'GenSan 1F', 'Active', '05:23:15', '16', '3', '510', '252', '2025-11-11 09:22:50');
INSERT INTO `agents` VALUES ('2', 'AG-1095', 'John Davis', '1', 'WFH', null, 'Active', '04:51:42', '22', '1', '468', '210', '2025-11-11 09:22:50');
INSERT INTO `agents` VALUES ('3', 'AG-1138', 'Maria Garcia', '1', 'Onsite', 'Cebu 9F', 'Idle', '06:12:08', '25', '5', '408', '312', '2025-11-11 09:22:50');
INSERT INTO `agents` VALUES ('4', 'AG-1156', 'Robert Chen', '1', 'WFH', null, 'Active', '03:38:52', '15', '2', '552', '378', '2025-11-11 09:22:50');
INSERT INTO `agents` VALUES ('5', 'AG-1189', 'Emily Johnson', '1', 'Onsite', 'GenSan 2F', 'Idle', '05:45:33', '28', '7', '372', '288', '2025-11-11 09:22:50');
INSERT INTO `agents` VALUES ('6', 'AG-1203', 'Michael Brown', '1', 'Onsite', 'Cebu 10F', 'Active', '07:15:20', '31', '4', '606', '432', '2025-11-11 09:22:50');
INSERT INTO `agents` VALUES ('7', 'AG-1247', 'Jennifer Lee', '1', 'WFH', null, 'Not Ready', '02:28:45', '12', '1', '528', '330', '2025-11-11 09:22:50');
INSERT INTO `agents` VALUES ('8', 'AG-1289', 'David Martinez', '1', 'Onsite', 'Cebu 4F', 'Idle', '06:03:18', '20', '6', '450', '294', '2025-11-11 09:22:50');
INSERT INTO `agents` VALUES ('9', 'AG-2200', 'William Davis', '2', 'Onsite', 'Cebu 4F', 'Not Ready', '03:54:21', '29', '4', '612', '258', '2025-11-19 10:18:43');
INSERT INTO `agents` VALUES ('10', 'AG-2201', 'Thomas Wilson', '2', 'WFH', null, 'Idle', '08:57:37', '34', '5', '496', '417', '2025-11-19 10:18:43');
INSERT INTO `agents` VALUES ('11', 'AG-2202', 'Robert Johnson', '2', 'Onsite', 'GenSan 1F', 'Active', '02:53:46', '14', '3', '476', '446', '2025-11-19 10:18:43');
INSERT INTO `agents` VALUES ('12', 'AG-2203', 'Linda Garcia', '2', 'WFH', null, 'Active', '02:40:48', '20', '6', '484', '426', '2025-11-19 10:18:43');
INSERT INTO `agents` VALUES ('13', 'AG-2204', 'David Anderson', '2', 'Onsite', 'Cebu 9F', 'Active', '03:29:45', '23', '3', '412', '425', '2025-11-19 10:18:43');
INSERT INTO `agents` VALUES ('14', 'AG-2205', 'Emily Taylor', '2', 'Onsite', 'GenSan 2F', 'Active', '08:31:40', '21', '6', '418', '418', '2025-11-19 10:18:43');
INSERT INTO `agents` VALUES ('15', 'AG-2206', 'Michael Jones', '2', 'Onsite', 'Cebu 9F', 'Idle', '08:01:59', '11', '6', '442', '430', '2025-11-19 10:18:43');
INSERT INTO `agents` VALUES ('16', 'AG-2207', 'Jessica Rodriguez', '2', 'Onsite', 'Cebu 10F', 'Not Ready', '07:31:15', '16', '8', '453', '295', '2025-11-19 10:18:43');
INSERT INTO `agents` VALUES ('17', 'AG-2208', 'Mary Smith', '2', 'WFH', null, 'Active', '04:54:00', '24', '1', '633', '358', '2025-11-19 10:18:43');
INSERT INTO `agents` VALUES ('18', 'AG-2209', 'Linda Davis', '2', 'WFH', null, 'Active', '08:23:24', '18', '7', '337', '350', '2025-11-19 10:18:43');
INSERT INTO `agents` VALUES ('19', 'AG-2300', 'Patricia Hernandez', '3', 'Onsite', 'GenSan 1F', 'Not Ready', '07:28:24', '29', '8', '581', '239', '2025-11-19 10:18:43');
INSERT INTO `agents` VALUES ('20', 'AG-2301', 'David Wilson', '3', 'Onsite', 'Cebu 4F', 'Active', '02:24:52', '10', '2', '564', '201', '2025-11-19 10:18:43');
INSERT INTO `agents` VALUES ('21', 'AG-2302', 'Jessica Williams', '3', 'Onsite', 'GenSan 2F', 'Active', '05:05:48', '31', '8', '529', '321', '2025-11-19 10:18:43');
INSERT INTO `agents` VALUES ('22', 'AG-2303', 'David Lopez', '3', 'Onsite', 'Manila 3F', 'Active', '03:22:00', '34', '2', '482', '218', '2025-11-19 10:18:43');
INSERT INTO `agents` VALUES ('23', 'AG-2304', 'Sarah Garcia', '3', 'Onsite', 'Cebu 10F', 'Active', '04:14:35', '20', '6', '555', '215', '2025-11-19 10:18:43');
INSERT INTO `agents` VALUES ('24', 'AG-2305', 'Jessica Johnson', '3', 'Onsite', 'Cebu 10F', 'Idle', '04:53:32', '23', '7', '301', '408', '2025-11-19 10:18:43');
INSERT INTO `agents` VALUES ('25', 'AG-2306', 'Michael Johnson', '3', 'Onsite', 'GenSan 2F', 'Not Ready', '02:55:46', '21', '7', '505', '300', '2025-11-19 10:18:43');
INSERT INTO `agents` VALUES ('26', 'AG-2307', 'Sarah Lopez', '3', 'Onsite', 'Cebu 10F', 'Idle', '05:06:19', '30', '3', '589', '316', '2025-11-11 09:34:37');
INSERT INTO `agents` VALUES ('27', 'AG-2400', 'David Brown', '4', 'Onsite', 'Cebu 9F', 'Not Ready', '02:17:03', '15', '5', '348', '250', '2025-11-19 10:18:43');
INSERT INTO `agents` VALUES ('28', 'AG-2401', 'John Wilson', '4', 'Onsite', 'Cebu 10F', 'Idle', '08:22:49', '31', '5', '407', '302', '2025-11-19 10:18:43');
INSERT INTO `agents` VALUES ('29', 'AG-2402', 'Lisa Brown', '4', 'WFH', null, 'Not Ready', '07:18:09', '11', '1', '419', '360', '2025-11-19 10:18:43');
INSERT INTO `agents` VALUES ('30', 'AG-2403', 'Michael Taylor', '4', 'WFH', null, 'Not Ready', '05:39:06', '30', '8', '378', '438', '2025-11-19 10:18:43');
INSERT INTO `agents` VALUES ('31', 'AG-2404', 'Robert Miller', '4', 'Onsite', 'GenSan 1F', 'Active', '06:03:58', '24', '7', '318', '206', '2025-11-19 10:18:43');
INSERT INTO `agents` VALUES ('32', 'AG-2405', 'John Lopez', '4', 'Onsite', 'Manila 3F', 'Idle', '06:24:48', '28', '4', '593', '212', '2025-11-19 10:18:43');
INSERT INTO `agents` VALUES ('33', 'AG-2500', 'Emily Miller', '5', 'Onsite', 'Cebu 4F', 'Active', '02:47:22', '31', '5', '372', '261', '2025-11-19 10:18:43');
INSERT INTO `agents` VALUES ('34', 'AG-2501', 'David Smith', '5', 'WFH', null, 'Idle', '03:53:45', '16', '1', '681', '210', '2025-11-19 10:18:43');
INSERT INTO `agents` VALUES ('35', 'AG-2502', 'James Miller', '5', 'WFH', null, 'Active', '05:25:47', '25', '4', '378', '393', '2025-11-19 10:18:43');
INSERT INTO `agents` VALUES ('36', 'AG-2503', 'Thomas Williams', '5', 'WFH', null, 'Active', '04:02:19', '26', '4', '493', '343', '2025-11-19 10:18:43');
INSERT INTO `agents` VALUES ('37', 'AG-2504', 'David Garcia', '5', 'Onsite', 'Cebu 4F', 'Active', '05:12:43', '28', '4', '382', '366', '2025-11-19 10:18:43');
INSERT INTO `agents` VALUES ('38', 'AG-2505', 'David Davis', '5', 'Onsite', 'GenSan 1F', 'Idle', '02:22:29', '14', '2', '594', '441', '2025-11-19 10:18:43');
INSERT INTO `agents` VALUES ('39', 'AG-2600', 'Linda Jones', '6', 'WFH', null, 'Active', '06:17:33', '11', '7', '321', '271', '2025-11-19 10:18:43');
INSERT INTO `agents` VALUES ('40', 'AG-2601', 'Sarah Anderson', '6', 'WFH', null, 'Idle', '03:35:46', '27', '7', '603', '357', '2025-11-19 10:18:43');
INSERT INTO `agents` VALUES ('41', 'AG-2602', 'Jennifer Anderson', '6', 'Onsite', 'GenSan 2F', 'Active', '03:09:11', '22', '5', '361', '436', '2025-11-19 10:18:43');
INSERT INTO `agents` VALUES ('42', 'AG-2603', 'William Hernandez', '6', 'Onsite', 'Cebu 4F', 'Idle', '05:06:19', '30', '3', '589', '316', '2025-11-19 10:18:43');
INSERT INTO `agents` VALUES ('43', 'AG-2604', 'Thomas Lopez', '6', 'Onsite', 'GenSan 1F', 'Active', '04:32:56', '19', '7', '392', '242', '2025-11-19 10:18:43');
INSERT INTO `agents` VALUES ('44', 'AG-2605', 'Linda Davis', '6', 'WFH', null, 'Idle', '02:50:16', '23', '6', '478', '191', '2025-11-19 10:18:43');
INSERT INTO `agents` VALUES ('45', 'AG-2606', 'Lisa Lopez', '6', 'WFH', null, 'Idle', '02:47:24', '29', '6', '501', '307', '2025-11-19 10:18:43');
INSERT INTO `agents` VALUES ('46', 'AG-2406', 'Jessica Rodriguez', '4', 'Onsite', 'Cebu 10F', 'Active', '08:35:36', '11', '1', '695', '210', '2025-11-19 10:18:43');
INSERT INTO `agents` VALUES ('47', 'AG-2607', 'Michael Taylor', '6', 'WFH', null, 'Active', '06:03:13', '27', '7', '542', '223', '2025-11-19 10:18:43');
INSERT INTO `agents` VALUES ('48', 'AG-2608', 'Robert Miller', '6', 'Onsite', 'GenSan 1F', 'Active', '03:52:38', '20', '2', '329', '432', '2025-11-19 10:18:43');
INSERT INTO `agents` VALUES ('49', 'AG-2609', 'John Lopez', '6', 'Onsite', 'Manila 3F', 'Idle', '03:39:23', '23', '2', '462', '253', '2025-11-19 10:18:43');
INSERT INTO `forecast_data` VALUES ('1', '1', '08:00:00', '154', '170', '2025-11-11');
INSERT INTO `forecast_data` VALUES ('2', '1', '08:30:00', '162', '143', '2025-11-11');
INSERT INTO `forecast_data` VALUES ('3', '1', '09:00:00', '159', '186', '2025-11-11');
INSERT INTO `forecast_data` VALUES ('4', '1', '09:30:00', '140', '168', '2025-11-11');
INSERT INTO `forecast_data` VALUES ('5', '1', '10:00:00', '143', '182', '2025-11-11');
INSERT INTO `forecast_data` VALUES ('6', '2', '08:00:00', '176', '172', '2025-11-11');
INSERT INTO `forecast_data` VALUES ('7', '2', '08:30:00', '148', '176', '2025-11-11');
INSERT INTO `forecast_data` VALUES ('8', '2', '09:00:00', '187', '160', '2025-11-11');
INSERT INTO `forecast_data` VALUES ('9', '2', '09:30:00', '184', '160', '2025-11-11');
INSERT INTO `forecast_data` VALUES ('10', '2', '10:00:00', '169', '163', '2025-11-11');
INSERT INTO `forecast_data` VALUES ('11', '3', '08:00:00', '182', '151', '2025-11-11');
INSERT INTO `forecast_data` VALUES ('12', '3', '08:30:00', '149', '186', '2025-11-11');
INSERT INTO `forecast_data` VALUES ('13', '3', '09:00:00', '152', '142', '2025-11-11');
INSERT INTO `forecast_data` VALUES ('14', '3', '09:30:00', '182', '156', '2025-11-11');
INSERT INTO `forecast_data` VALUES ('15', '3', '10:00:00', '191', '151', '2025-11-11');
INSERT INTO `forecast_data` VALUES ('16', '4', '08:00:00', '182', '181', '2025-11-11');
INSERT INTO `forecast_data` VALUES ('17', '4', '08:30:00', '143', '168', '2025-11-11');
INSERT INTO `forecast_data` VALUES ('18', '4', '09:00:00', '146', '188', '2025-11-11');
INSERT INTO `forecast_data` VALUES ('19', '4', '09:30:00', '161', '160', '2025-11-11');
INSERT INTO `forecast_data` VALUES ('20', '4', '10:00:00', '158', '183', '2025-11-11');
INSERT INTO `forecast_data` VALUES ('21', '5', '08:00:00', '145', '172', '2025-11-11');
INSERT INTO `forecast_data` VALUES ('22', '5', '08:30:00', '158', '145', '2025-11-11');
INSERT INTO `forecast_data` VALUES ('23', '5', '09:00:00', '190', '168', '2025-11-11');
INSERT INTO `forecast_data` VALUES ('24', '5', '09:30:00', '175', '181', '2025-11-11');
INSERT INTO `forecast_data` VALUES ('25', '5', '10:00:00', '142', '142', '2025-11-11');
INSERT INTO `forecast_data` VALUES ('26', '6', '08:00:00', '149', '167', '2025-11-11');
INSERT INTO `forecast_data` VALUES ('27', '6', '08:30:00', '153', '161', '2025-11-11');
INSERT INTO `forecast_data` VALUES ('28', '6', '09:00:00', '164', '160', '2025-11-11');
INSERT INTO `forecast_data` VALUES ('29', '6', '09:30:00', '178', '167', '2025-11-11');
INSERT INTO `forecast_data` VALUES ('30', '6', '10:00:00', '161', '190', '2025-11-11');
INSERT INTO `forecast_data` VALUES ('31', '1', '08:00:00', '151', '184', '2025-11-19');
INSERT INTO `forecast_data` VALUES ('32', '1', '08:30:00', '194', '179', '2025-11-19');
INSERT INTO `forecast_data` VALUES ('33', '1', '09:00:00', '172', '157', '2025-11-19');
INSERT INTO `forecast_data` VALUES ('34', '1', '09:30:00', '142', '169', '2025-11-19');
INSERT INTO `forecast_data` VALUES ('35', '1', '10:00:00', '153', '160', '2025-11-19');
INSERT INTO `forecast_data` VALUES ('36', '2', '08:00:00', '174', '166', '2025-11-19');
INSERT INTO `forecast_data` VALUES ('37', '2', '08:30:00', '140', '141', '2025-11-19');
INSERT INTO `forecast_data` VALUES ('38', '2', '09:00:00', '156', '156', '2025-11-19');
INSERT INTO `forecast_data` VALUES ('39', '2', '09:30:00', '153', '174', '2025-11-19');
INSERT INTO `forecast_data` VALUES ('40', '2', '10:00:00', '149', '149', '2025-11-19');
INSERT INTO `forecast_data` VALUES ('41', '3', '08:00:00', '182', '157', '2025-11-19');
INSERT INTO `forecast_data` VALUES ('42', '3', '08:30:00', '185', '183', '2025-11-19');
INSERT INTO `forecast_data` VALUES ('43', '3', '09:00:00', '192', '163', '2025-11-19');
INSERT INTO `forecast_data` VALUES ('44', '3', '09:30:00', '159', '167', '2025-11-19');
INSERT INTO `forecast_data` VALUES ('45', '3', '10:00:00', '174', '140', '2025-11-19');
INSERT INTO `forecast_data` VALUES ('46', '4', '08:00:00', '160', '189', '2025-11-19');
INSERT INTO `forecast_data` VALUES ('47', '4', '08:30:00', '146', '163', '2025-11-19');
INSERT INTO `forecast_data` VALUES ('48', '4', '09:00:00', '192', '156', '2025-11-19');
INSERT INTO `forecast_data` VALUES ('49', '4', '09:30:00', '156', '180', '2025-11-19');
INSERT INTO `forecast_data` VALUES ('50', '4', '10:00:00', '178', '158', '2025-11-19');
INSERT INTO `forecast_data` VALUES ('51', '5', '08:00:00', '167', '164', '2025-11-19');
INSERT INTO `forecast_data` VALUES ('52', '5', '08:30:00', '178', '155', '2025-11-19');
INSERT INTO `forecast_data` VALUES ('53', '5', '09:00:00', '171', '163', '2025-11-19');
INSERT INTO `forecast_data` VALUES ('54', '5', '09:30:00', '169', '182', '2025-11-19');
INSERT INTO `forecast_data` VALUES ('55', '5', '10:00:00', '186', '151', '2025-11-19');
INSERT INTO `forecast_data` VALUES ('56', '6', '08:00:00', '157', '149', '2025-11-19');
INSERT INTO `forecast_data` VALUES ('57', '6', '08:30:00', '148', '177', '2025-11-19');
INSERT INTO `forecast_data` VALUES ('58', '6', '09:00:00', '175', '144', '2025-11-19');
INSERT INTO `forecast_data` VALUES ('59', '6', '09:30:00', '189', '163', '2025-11-19');
INSERT INTO `forecast_data` VALUES ('60', '6', '10:00:00', '173', '178', '2025-11-19');
INSERT INTO `forecast_data` VALUES ('61', '1', '08:00:00', '151', '184', '2025-11-24');
INSERT INTO `forecast_data` VALUES ('62', '1', '08:30:00', '194', '179', '2025-11-24');
INSERT INTO `forecast_data` VALUES ('63', '1', '09:00:00', '172', '157', '2025-11-24');
INSERT INTO `forecast_data` VALUES ('64', '1', '09:30:00', '142', '169', '2025-11-24');
INSERT INTO `forecast_data` VALUES ('65', '1', '10:00:00', '153', '160', '2025-11-24');
INSERT INTO `forecast_data` VALUES ('66', '2', '08:00:00', '174', '166', '2025-11-24');
INSERT INTO `forecast_data` VALUES ('67', '2', '08:30:00', '140', '141', '2025-11-24');
INSERT INTO `forecast_data` VALUES ('68', '2', '09:00:00', '156', '156', '2025-11-24');
INSERT INTO `forecast_data` VALUES ('69', '2', '09:30:00', '153', '174', '2025-11-24');
INSERT INTO `forecast_data` VALUES ('70', '2', '10:00:00', '149', '149', '2025-11-24');
INSERT INTO `forecast_data` VALUES ('71', '3', '08:00:00', '182', '157', '2025-11-24');
INSERT INTO `forecast_data` VALUES ('72', '3', '08:30:00', '185', '183', '2025-11-24');
INSERT INTO `forecast_data` VALUES ('73', '3', '09:00:00', '192', '163', '2025-11-24');
INSERT INTO `forecast_data` VALUES ('74', '3', '09:30:00', '159', '167', '2025-11-24');
INSERT INTO `forecast_data` VALUES ('75', '3', '10:00:00', '174', '140', '2025-11-24');
INSERT INTO `forecast_data` VALUES ('76', '4', '08:00:00', '160', '189', '2025-11-24');
INSERT INTO `forecast_data` VALUES ('77', '4', '08:30:00', '146', '163', '2025-11-24');
INSERT INTO `forecast_data` VALUES ('78', '4', '09:00:00', '192', '156', '2025-11-24');
INSERT INTO `forecast_data` VALUES ('79', '4', '09:30:00', '156', '180', '2025-11-24');
INSERT INTO `forecast_data` VALUES ('80', '4', '10:00:00', '178', '158', '2025-11-24');
INSERT INTO `forecast_data` VALUES ('81', '5', '08:00:00', '167', '164', '2025-11-24');
INSERT INTO `forecast_data` VALUES ('82', '5', '08:30:00', '178', '155', '2025-11-24');
INSERT INTO `forecast_data` VALUES ('83', '5', '09:00:00', '171', '163', '2025-11-24');
INSERT INTO `forecast_data` VALUES ('84', '5', '09:30:00', '169', '182', '2025-11-24');
INSERT INTO `forecast_data` VALUES ('85', '5', '10:00:00', '186', '151', '2025-11-24');
INSERT INTO `forecast_data` VALUES ('86', '6', '08:00:00', '157', '149', '2025-11-24');
INSERT INTO `forecast_data` VALUES ('87', '6', '08:30:00', '148', '177', '2025-11-24');
INSERT INTO `forecast_data` VALUES ('88', '6', '09:00:00', '175', '144', '2025-11-24');
INSERT INTO `forecast_data` VALUES ('89', '6', '09:30:00', '189', '163', '2025-11-24');
INSERT INTO `forecast_data` VALUES ('90', '6', '10:00:00', '173', '178', '2025-11-24');
INSERT INTO `forecast_data` VALUES ('91', '1', '08:00:00', '151', '184', '2025-12-01');
INSERT INTO `forecast_data` VALUES ('92', '1', '08:30:00', '194', '179', '2025-12-01');
INSERT INTO `forecast_data` VALUES ('93', '1', '09:00:00', '172', '157', '2025-12-01');
INSERT INTO `forecast_data` VALUES ('94', '1', '09:30:00', '142', '169', '2025-12-01');
INSERT INTO `forecast_data` VALUES ('95', '1', '10:00:00', '153', '160', '2025-12-01');
INSERT INTO `forecast_data` VALUES ('96', '2', '08:00:00', '174', '166', '2025-12-01');
INSERT INTO `forecast_data` VALUES ('97', '2', '08:30:00', '140', '141', '2025-12-01');
INSERT INTO `forecast_data` VALUES ('98', '2', '09:00:00', '156', '156', '2025-12-01');
INSERT INTO `forecast_data` VALUES ('99', '2', '09:30:00', '153', '174', '2025-12-01');
INSERT INTO `forecast_data` VALUES ('100', '2', '10:00:00', '149', '149', '2025-12-01');
INSERT INTO `forecast_data` VALUES ('101', '3', '08:00:00', '182', '157', '2025-12-01');
INSERT INTO `forecast_data` VALUES ('102', '3', '08:30:00', '185', '183', '2025-12-01');
INSERT INTO `forecast_data` VALUES ('103', '3', '09:00:00', '192', '163', '2025-12-01');
INSERT INTO `forecast_data` VALUES ('104', '3', '09:30:00', '159', '167', '2025-12-01');
INSERT INTO `forecast_data` VALUES ('105', '3', '10:00:00', '174', '140', '2025-12-01');
INSERT INTO `forecast_data` VALUES ('106', '4', '08:00:00', '160', '189', '2025-12-01');
INSERT INTO `forecast_data` VALUES ('107', '4', '08:30:00', '146', '163', '2025-12-01');
INSERT INTO `forecast_data` VALUES ('108', '4', '09:00:00', '192', '156', '2025-12-01');
INSERT INTO `forecast_data` VALUES ('109', '4', '09:30:00', '156', '180', '2025-12-01');
INSERT INTO `forecast_data` VALUES ('110', '4', '10:00:00', '178', '158', '2025-12-01');
INSERT INTO `forecast_data` VALUES ('111', '5', '08:00:00', '167', '164', '2025-12-01');
INSERT INTO `forecast_data` VALUES ('112', '5', '08:30:00', '178', '155', '2025-12-01');
INSERT INTO `forecast_data` VALUES ('113', '5', '09:00:00', '171', '163', '2025-12-01');
INSERT INTO `forecast_data` VALUES ('114', '5', '09:30:00', '169', '182', '2025-12-01');
INSERT INTO `forecast_data` VALUES ('115', '5', '10:00:00', '186', '151', '2025-12-01');
INSERT INTO `forecast_data` VALUES ('116', '6', '08:00:00', '157', '149', '2025-12-01');
INSERT INTO `forecast_data` VALUES ('117', '6', '08:30:00', '148', '177', '2025-12-01');
INSERT INTO `forecast_data` VALUES ('118', '6', '09:00:00', '175', '144', '2025-12-01');
INSERT INTO `forecast_data` VALUES ('119', '6', '09:30:00', '189', '163', '2025-12-01');
INSERT INTO `forecast_data` VALUES ('120', '6', '10:00:00', '173', '178', '2025-12-01');
INSERT INTO `forecast_data` VALUES ('121', '1', '08:00:00', '151', '184', '2025-12-02');
INSERT INTO `forecast_data` VALUES ('122', '1', '08:30:00', '194', '179', '2025-12-02');
INSERT INTO `forecast_data` VALUES ('123', '1', '09:00:00', '172', '157', '2025-12-02');
INSERT INTO `forecast_data` VALUES ('124', '1', '09:30:00', '142', '169', '2025-12-02');
INSERT INTO `forecast_data` VALUES ('125', '1', '10:00:00', '153', '160', '2025-12-02');
INSERT INTO `forecast_data` VALUES ('126', '2', '08:00:00', '174', '166', '2025-12-02');
INSERT INTO `forecast_data` VALUES ('127', '2', '08:30:00', '140', '141', '2025-12-02');
INSERT INTO `forecast_data` VALUES ('128', '2', '09:00:00', '156', '156', '2025-12-02');
INSERT INTO `forecast_data` VALUES ('129', '2', '09:30:00', '153', '174', '2025-12-02');
INSERT INTO `forecast_data` VALUES ('130', '2', '10:00:00', '149', '149', '2025-12-02');
INSERT INTO `forecast_data` VALUES ('131', '3', '08:00:00', '182', '157', '2025-12-02');
INSERT INTO `forecast_data` VALUES ('132', '3', '08:30:00', '185', '183', '2025-12-02');
INSERT INTO `forecast_data` VALUES ('133', '3', '09:00:00', '192', '163', '2025-12-02');
INSERT INTO `forecast_data` VALUES ('134', '3', '09:30:00', '159', '167', '2025-12-02');
INSERT INTO `forecast_data` VALUES ('135', '3', '10:00:00', '174', '140', '2025-12-02');
INSERT INTO `forecast_data` VALUES ('136', '4', '08:00:00', '160', '189', '2025-12-02');
INSERT INTO `forecast_data` VALUES ('137', '4', '08:30:00', '146', '163', '2025-12-02');
INSERT INTO `forecast_data` VALUES ('138', '4', '09:00:00', '192', '156', '2025-12-02');
INSERT INTO `forecast_data` VALUES ('139', '4', '09:30:00', '156', '180', '2025-12-02');
INSERT INTO `forecast_data` VALUES ('140', '4', '10:00:00', '178', '158', '2025-12-02');
INSERT INTO `forecast_data` VALUES ('141', '5', '08:00:00', '167', '164', '2025-12-02');
INSERT INTO `forecast_data` VALUES ('142', '5', '08:30:00', '178', '155', '2025-12-02');
INSERT INTO `forecast_data` VALUES ('143', '5', '09:00:00', '171', '163', '2025-12-02');
INSERT INTO `forecast_data` VALUES ('144', '5', '09:30:00', '169', '182', '2025-12-02');
INSERT INTO `forecast_data` VALUES ('145', '5', '10:00:00', '186', '151', '2025-12-02');
INSERT INTO `forecast_data` VALUES ('146', '6', '08:00:00', '157', '149', '2025-12-02');
INSERT INTO `forecast_data` VALUES ('147', '6', '08:30:00', '148', '177', '2025-12-02');
INSERT INTO `forecast_data` VALUES ('148', '6', '09:00:00', '175', '144', '2025-12-02');
INSERT INTO `forecast_data` VALUES ('149', '6', '09:30:00', '189', '163', '2025-12-02');
INSERT INTO `forecast_data` VALUES ('150', '6', '10:00:00', '173', '178', '2025-12-02');
INSERT INTO `forecast_data` VALUES ('151', '1', '08:00:00', '151', '184', '2025-12-11');
INSERT INTO `forecast_data` VALUES ('152', '1', '08:30:00', '194', '179', '2025-12-11');
INSERT INTO `forecast_data` VALUES ('153', '1', '09:00:00', '172', '157', '2025-12-11');
INSERT INTO `forecast_data` VALUES ('154', '1', '09:30:00', '142', '169', '2025-12-11');
INSERT INTO `forecast_data` VALUES ('155', '1', '10:00:00', '153', '160', '2025-12-11');
INSERT INTO `forecast_data` VALUES ('156', '2', '08:00:00', '174', '166', '2025-12-11');
INSERT INTO `forecast_data` VALUES ('157', '2', '08:30:00', '140', '141', '2025-12-11');
INSERT INTO `forecast_data` VALUES ('158', '2', '09:00:00', '156', '156', '2025-12-11');
INSERT INTO `forecast_data` VALUES ('159', '2', '09:30:00', '153', '174', '2025-12-11');
INSERT INTO `forecast_data` VALUES ('160', '2', '10:00:00', '149', '149', '2025-12-11');
INSERT INTO `forecast_data` VALUES ('161', '3', '08:00:00', '182', '157', '2025-12-11');
INSERT INTO `forecast_data` VALUES ('162', '3', '08:30:00', '185', '183', '2025-12-11');
INSERT INTO `forecast_data` VALUES ('163', '3', '09:00:00', '192', '163', '2025-12-11');
INSERT INTO `forecast_data` VALUES ('164', '3', '09:30:00', '159', '167', '2025-12-11');
INSERT INTO `forecast_data` VALUES ('165', '3', '10:00:00', '174', '140', '2025-12-11');
INSERT INTO `forecast_data` VALUES ('166', '4', '08:00:00', '160', '189', '2025-12-11');
INSERT INTO `forecast_data` VALUES ('167', '4', '08:30:00', '146', '163', '2025-12-11');
INSERT INTO `forecast_data` VALUES ('168', '4', '09:00:00', '192', '156', '2025-12-11');
INSERT INTO `forecast_data` VALUES ('169', '4', '09:30:00', '156', '180', '2025-12-11');
INSERT INTO `forecast_data` VALUES ('170', '4', '10:00:00', '178', '158', '2025-12-11');
INSERT INTO `forecast_data` VALUES ('171', '5', '08:00:00', '167', '164', '2025-12-11');
INSERT INTO `forecast_data` VALUES ('172', '5', '08:30:00', '178', '155', '2025-12-11');
INSERT INTO `forecast_data` VALUES ('173', '5', '09:00:00', '171', '163', '2025-12-11');
INSERT INTO `forecast_data` VALUES ('174', '5', '09:30:00', '169', '182', '2025-12-11');
INSERT INTO `forecast_data` VALUES ('175', '5', '10:00:00', '186', '151', '2025-12-11');
INSERT INTO `forecast_data` VALUES ('176', '6', '08:00:00', '157', '149', '2025-12-11');
INSERT INTO `forecast_data` VALUES ('177', '6', '08:30:00', '148', '177', '2025-12-11');
INSERT INTO `forecast_data` VALUES ('178', '6', '09:00:00', '175', '144', '2025-12-11');
INSERT INTO `forecast_data` VALUES ('179', '6', '09:30:00', '189', '163', '2025-12-11');
INSERT INTO `forecast_data` VALUES ('180', '6', '10:00:00', '173', '178', '2025-12-11');
INSERT INTO `queues` VALUES ('1', 'Tech Tier 2', '1', '19', '261', 'red', '2025-11-11 09:22:50');
INSERT INTO `queues` VALUES ('2', 'Billing Support', '1', '12', '195', 'yellow', '2025-11-11 09:22:50');
INSERT INTO `queues` VALUES ('3', 'General Inquiries', '1', '8', '128', 'green', '2025-11-11 09:22:50');
INSERT INTO `queues` VALUES ('4', 'Tech Tier 1', '1', '15', '212', 'yellow', '2025-11-11 09:22:50');
INSERT INTO `queues` VALUES ('5', 'Account Services', '1', '5', '83', 'green', '2025-11-11 09:22:50');
INSERT INTO `queues` VALUES ('6', 'Tech Support Tier 1', '2', '14', '162', 'green', '2025-11-19 10:18:43');
INSERT INTO `queues` VALUES ('7', 'Tech Support Tier 2', '2', '20', '206', 'yellow', '2025-11-19 10:18:43');
INSERT INTO `queues` VALUES ('8', 'Billing Support', '2', '13', '197', 'yellow', '2025-11-19 10:18:43');
INSERT INTO `queues` VALUES ('9', 'General Inquiries', '2', '11', '103', 'green', '2025-11-19 10:18:43');
INSERT INTO `queues` VALUES ('10', 'Tech Support Tier 1', '3', '17', '155', 'green', '2025-11-19 10:18:43');
INSERT INTO `queues` VALUES ('11', 'Tech Support Tier 2', '3', '15', '257', 'red', '2025-11-19 10:18:43');
INSERT INTO `queues` VALUES ('12', 'Billing Support', '3', '11', '121', 'green', '2025-11-19 10:18:43');
INSERT INTO `queues` VALUES ('13', 'General Inquiries', '3', '12', '132', 'green', '2025-11-19 10:18:43');
INSERT INTO `queues` VALUES ('14', 'Account Services', '3', '6', '104', 'green', '2025-11-19 10:18:43');
INSERT INTO `queues` VALUES ('15', 'Tech Support Tier 1', '4', '17', '207', 'yellow', '2025-11-19 10:18:43');
INSERT INTO `queues` VALUES ('16', 'Tech Support Tier 2', '4', '20', '295', 'red', '2025-11-19 10:18:43');
INSERT INTO `queues` VALUES ('17', 'Billing Support', '4', '12', '147', 'green', '2025-11-19 10:18:43');
INSERT INTO `queues` VALUES ('18', 'General Inquiries', '4', '7', '119', 'green', '2025-11-19 10:18:43');
INSERT INTO `queues` VALUES ('19', 'Account Services', '4', '8', '61', 'green', '2025-11-19 10:18:43');
INSERT INTO `queues` VALUES ('20', 'Tech Support Tier 1', '5', '18', '202', 'yellow', '2025-11-19 10:18:43');
INSERT INTO `queues` VALUES ('21', 'Tech Support Tier 2', '5', '15', '244', 'red', '2025-11-19 10:18:43');
INSERT INTO `queues` VALUES ('22', 'Billing Support', '5', '16', '213', 'yellow', '2025-11-19 10:18:43');
INSERT INTO `queues` VALUES ('23', 'General Inquiries', '5', '5', '147', 'green', '2025-11-19 10:18:43');
INSERT INTO `queues` VALUES ('24', 'Account Services', '5', '3', '79', 'green', '2025-11-11 09:34:37');
INSERT INTO `queues` VALUES ('25', 'Tech Support Tier 1', '6', '12', '172', 'green', '2025-11-19 10:18:43');
INSERT INTO `queues` VALUES ('26', 'Tech Support Tier 2', '6', '19', '233', 'yellow', '2025-11-19 10:18:43');
INSERT INTO `queues` VALUES ('27', 'Billing Support', '6', '15', '154', 'green', '2025-11-19 10:18:43');
INSERT INTO `queues` VALUES ('28', 'General Inquiries', '6', '5', '94', 'green', '2025-11-19 10:18:43');
INSERT INTO `queues` VALUES ('29', 'Sales Support', '3', '9', '127', 'green', '2025-11-19 10:18:43');
INSERT INTO `sla_trend` VALUES ('1', '1', '08:00:00', '81.00', '35', '2025-11-11');
INSERT INTO `sla_trend` VALUES ('2', '1', '08:15:00', '87.00', '28', '2025-11-11');
INSERT INTO `sla_trend` VALUES ('3', '1', '08:30:00', '92.00', '38', '2025-11-11');
INSERT INTO `sla_trend` VALUES ('4', '1', '08:45:00', '91.00', '24', '2025-11-11');
INSERT INTO `sla_trend` VALUES ('5', '1', '09:00:00', '84.00', '26', '2025-11-11');
INSERT INTO `sla_trend` VALUES ('6', '1', '09:15:00', '88.00', '31', '2025-11-11');
INSERT INTO `sla_trend` VALUES ('7', '1', '09:30:00', '95.00', '36', '2025-11-11');
INSERT INTO `sla_trend` VALUES ('8', '2', '08:00:00', '94.00', '40', '2025-11-11');
INSERT INTO `sla_trend` VALUES ('9', '2', '08:15:00', '88.00', '36', '2025-11-11');
INSERT INTO `sla_trend` VALUES ('10', '2', '08:30:00', '84.00', '32', '2025-11-11');
INSERT INTO `sla_trend` VALUES ('11', '2', '08:45:00', '82.00', '21', '2025-11-11');
INSERT INTO `sla_trend` VALUES ('12', '2', '09:00:00', '91.00', '40', '2025-11-11');
INSERT INTO `sla_trend` VALUES ('13', '2', '09:15:00', '89.00', '40', '2025-11-11');
INSERT INTO `sla_trend` VALUES ('14', '2', '09:30:00', '89.00', '25', '2025-11-11');
INSERT INTO `sla_trend` VALUES ('15', '3', '08:00:00', '80.00', '28', '2025-11-11');
INSERT INTO `sla_trend` VALUES ('16', '3', '08:15:00', '93.00', '20', '2025-11-11');
INSERT INTO `sla_trend` VALUES ('17', '3', '08:30:00', '83.00', '33', '2025-11-11');
INSERT INTO `sla_trend` VALUES ('18', '3', '08:45:00', '81.00', '27', '2025-11-11');
INSERT INTO `sla_trend` VALUES ('19', '3', '09:00:00', '85.00', '32', '2025-11-11');
INSERT INTO `sla_trend` VALUES ('20', '3', '09:15:00', '82.00', '37', '2025-11-11');
INSERT INTO `sla_trend` VALUES ('21', '3', '09:30:00', '81.00', '31', '2025-11-11');
INSERT INTO `sla_trend` VALUES ('22', '4', '08:00:00', '89.00', '32', '2025-11-11');
INSERT INTO `sla_trend` VALUES ('23', '4', '08:15:00', '92.00', '27', '2025-11-11');
INSERT INTO `sla_trend` VALUES ('24', '4', '08:30:00', '85.00', '24', '2025-11-11');
INSERT INTO `sla_trend` VALUES ('25', '4', '08:45:00', '81.00', '27', '2025-11-11');
INSERT INTO `sla_trend` VALUES ('26', '4', '09:00:00', '93.00', '35', '2025-11-11');
INSERT INTO `sla_trend` VALUES ('27', '4', '09:15:00', '82.00', '29', '2025-11-11');
INSERT INTO `sla_trend` VALUES ('28', '4', '09:30:00', '81.00', '37', '2025-11-11');
INSERT INTO `sla_trend` VALUES ('29', '5', '08:00:00', '93.00', '39', '2025-11-11');
INSERT INTO `sla_trend` VALUES ('30', '5', '08:15:00', '89.00', '30', '2025-11-11');
INSERT INTO `sla_trend` VALUES ('31', '5', '08:30:00', '83.00', '33', '2025-11-11');
INSERT INTO `sla_trend` VALUES ('32', '5', '08:45:00', '83.00', '29', '2025-11-11');
INSERT INTO `sla_trend` VALUES ('33', '5', '09:00:00', '82.00', '39', '2025-11-11');
INSERT INTO `sla_trend` VALUES ('34', '5', '09:15:00', '88.00', '34', '2025-11-11');
INSERT INTO `sla_trend` VALUES ('35', '5', '09:30:00', '92.00', '34', '2025-11-11');
INSERT INTO `sla_trend` VALUES ('36', '6', '08:00:00', '87.00', '38', '2025-11-11');
INSERT INTO `sla_trend` VALUES ('37', '6', '08:15:00', '92.00', '23', '2025-11-11');
INSERT INTO `sla_trend` VALUES ('38', '6', '08:30:00', '88.00', '20', '2025-11-11');
INSERT INTO `sla_trend` VALUES ('39', '6', '08:45:00', '86.00', '25', '2025-11-11');
INSERT INTO `sla_trend` VALUES ('40', '6', '09:00:00', '89.00', '36', '2025-11-11');
INSERT INTO `sla_trend` VALUES ('41', '6', '09:15:00', '87.00', '27', '2025-11-11');
INSERT INTO `sla_trend` VALUES ('42', '6', '09:30:00', '83.00', '25', '2025-11-11');
INSERT INTO `sla_trend` VALUES ('43', '1', '08:00:00', '93.00', '27', '2025-11-19');
INSERT INTO `sla_trend` VALUES ('44', '1', '08:15:00', '92.00', '39', '2025-11-19');
INSERT INTO `sla_trend` VALUES ('45', '1', '08:30:00', '86.00', '39', '2025-11-19');
INSERT INTO `sla_trend` VALUES ('46', '1', '08:45:00', '84.00', '36', '2025-11-19');
INSERT INTO `sla_trend` VALUES ('47', '1', '09:00:00', '85.00', '22', '2025-11-19');
INSERT INTO `sla_trend` VALUES ('48', '1', '09:15:00', '91.00', '20', '2025-11-19');
INSERT INTO `sla_trend` VALUES ('49', '1', '09:30:00', '81.00', '28', '2025-11-19');
INSERT INTO `sla_trend` VALUES ('50', '2', '08:00:00', '81.00', '39', '2025-11-19');
INSERT INTO `sla_trend` VALUES ('51', '2', '08:15:00', '87.00', '36', '2025-11-19');
INSERT INTO `sla_trend` VALUES ('52', '2', '08:30:00', '82.00', '24', '2025-11-19');
INSERT INTO `sla_trend` VALUES ('53', '2', '08:45:00', '92.00', '33', '2025-11-19');
INSERT INTO `sla_trend` VALUES ('54', '2', '09:00:00', '93.00', '21', '2025-11-19');
INSERT INTO `sla_trend` VALUES ('55', '2', '09:15:00', '94.00', '20', '2025-11-19');
INSERT INTO `sla_trend` VALUES ('56', '2', '09:30:00', '93.00', '24', '2025-11-19');
INSERT INTO `sla_trend` VALUES ('57', '3', '08:00:00', '83.00', '27', '2025-11-19');
INSERT INTO `sla_trend` VALUES ('58', '3', '08:15:00', '83.00', '37', '2025-11-19');
INSERT INTO `sla_trend` VALUES ('59', '3', '08:30:00', '87.00', '32', '2025-11-19');
INSERT INTO `sla_trend` VALUES ('60', '3', '08:45:00', '89.00', '35', '2025-11-19');
INSERT INTO `sla_trend` VALUES ('61', '3', '09:00:00', '80.00', '26', '2025-11-19');
INSERT INTO `sla_trend` VALUES ('62', '3', '09:15:00', '95.00', '21', '2025-11-19');
INSERT INTO `sla_trend` VALUES ('63', '3', '09:30:00', '93.00', '27', '2025-11-19');
INSERT INTO `sla_trend` VALUES ('64', '4', '08:00:00', '81.00', '32', '2025-11-19');
INSERT INTO `sla_trend` VALUES ('65', '4', '08:15:00', '81.00', '25', '2025-11-19');
INSERT INTO `sla_trend` VALUES ('66', '4', '08:30:00', '94.00', '30', '2025-11-19');
INSERT INTO `sla_trend` VALUES ('67', '4', '08:45:00', '92.00', '39', '2025-11-19');
INSERT INTO `sla_trend` VALUES ('68', '4', '09:00:00', '81.00', '30', '2025-11-19');
INSERT INTO `sla_trend` VALUES ('69', '4', '09:15:00', '82.00', '39', '2025-11-19');
INSERT INTO `sla_trend` VALUES ('70', '4', '09:30:00', '91.00', '37', '2025-11-19');
INSERT INTO `sla_trend` VALUES ('71', '5', '08:00:00', '81.00', '23', '2025-11-19');
INSERT INTO `sla_trend` VALUES ('72', '5', '08:15:00', '86.00', '23', '2025-11-19');
INSERT INTO `sla_trend` VALUES ('73', '5', '08:30:00', '94.00', '22', '2025-11-19');
INSERT INTO `sla_trend` VALUES ('74', '5', '08:45:00', '83.00', '37', '2025-11-19');
INSERT INTO `sla_trend` VALUES ('75', '5', '09:00:00', '87.00', '35', '2025-11-19');
INSERT INTO `sla_trend` VALUES ('76', '5', '09:15:00', '91.00', '29', '2025-11-19');
INSERT INTO `sla_trend` VALUES ('77', '5', '09:30:00', '81.00', '30', '2025-11-19');
INSERT INTO `sla_trend` VALUES ('78', '6', '08:00:00', '81.00', '25', '2025-11-19');
INSERT INTO `sla_trend` VALUES ('79', '6', '08:15:00', '90.00', '29', '2025-11-19');
INSERT INTO `sla_trend` VALUES ('80', '6', '08:30:00', '93.00', '20', '2025-11-19');
INSERT INTO `sla_trend` VALUES ('81', '6', '08:45:00', '88.00', '39', '2025-11-19');
INSERT INTO `sla_trend` VALUES ('82', '6', '09:00:00', '81.00', '38', '2025-11-19');
INSERT INTO `sla_trend` VALUES ('83', '6', '09:15:00', '87.00', '40', '2025-11-19');
INSERT INTO `sla_trend` VALUES ('84', '6', '09:30:00', '87.00', '33', '2025-11-19');
INSERT INTO `sla_trend` VALUES ('85', '1', '08:00:00', '93.00', '27', '2025-11-24');
INSERT INTO `sla_trend` VALUES ('86', '1', '08:15:00', '92.00', '39', '2025-11-24');
INSERT INTO `sla_trend` VALUES ('87', '1', '08:30:00', '86.00', '39', '2025-11-24');
INSERT INTO `sla_trend` VALUES ('88', '1', '08:45:00', '84.00', '36', '2025-11-24');
INSERT INTO `sla_trend` VALUES ('89', '1', '09:00:00', '85.00', '22', '2025-11-24');
INSERT INTO `sla_trend` VALUES ('90', '1', '09:15:00', '91.00', '20', '2025-11-24');
INSERT INTO `sla_trend` VALUES ('91', '1', '09:30:00', '81.00', '28', '2025-11-24');
INSERT INTO `sla_trend` VALUES ('92', '2', '08:00:00', '81.00', '39', '2025-11-24');
INSERT INTO `sla_trend` VALUES ('93', '2', '08:15:00', '87.00', '36', '2025-11-24');
INSERT INTO `sla_trend` VALUES ('94', '2', '08:30:00', '82.00', '24', '2025-11-24');
INSERT INTO `sla_trend` VALUES ('95', '2', '08:45:00', '92.00', '33', '2025-11-24');
INSERT INTO `sla_trend` VALUES ('96', '2', '09:00:00', '93.00', '21', '2025-11-24');
INSERT INTO `sla_trend` VALUES ('97', '2', '09:15:00', '94.00', '20', '2025-11-24');
INSERT INTO `sla_trend` VALUES ('98', '2', '09:30:00', '93.00', '24', '2025-11-24');
INSERT INTO `sla_trend` VALUES ('99', '3', '08:00:00', '83.00', '27', '2025-11-24');
INSERT INTO `sla_trend` VALUES ('100', '3', '08:15:00', '83.00', '37', '2025-11-24');
INSERT INTO `sla_trend` VALUES ('101', '3', '08:30:00', '87.00', '32', '2025-11-24');
INSERT INTO `sla_trend` VALUES ('102', '3', '08:45:00', '89.00', '35', '2025-11-24');
INSERT INTO `sla_trend` VALUES ('103', '3', '09:00:00', '80.00', '26', '2025-11-24');
INSERT INTO `sla_trend` VALUES ('104', '3', '09:15:00', '95.00', '21', '2025-11-24');
INSERT INTO `sla_trend` VALUES ('105', '3', '09:30:00', '93.00', '27', '2025-11-24');
INSERT INTO `sla_trend` VALUES ('106', '4', '08:00:00', '81.00', '32', '2025-11-24');
INSERT INTO `sla_trend` VALUES ('107', '4', '08:15:00', '81.00', '25', '2025-11-24');
INSERT INTO `sla_trend` VALUES ('108', '4', '08:30:00', '94.00', '30', '2025-11-24');
INSERT INTO `sla_trend` VALUES ('109', '4', '08:45:00', '92.00', '39', '2025-11-24');
INSERT INTO `sla_trend` VALUES ('110', '4', '09:00:00', '81.00', '30', '2025-11-24');
INSERT INTO `sla_trend` VALUES ('111', '4', '09:15:00', '82.00', '39', '2025-11-24');
INSERT INTO `sla_trend` VALUES ('112', '4', '09:30:00', '91.00', '37', '2025-11-24');
INSERT INTO `sla_trend` VALUES ('113', '5', '08:00:00', '81.00', '23', '2025-11-24');
INSERT INTO `sla_trend` VALUES ('114', '5', '08:15:00', '86.00', '23', '2025-11-24');
INSERT INTO `sla_trend` VALUES ('115', '5', '08:30:00', '94.00', '22', '2025-11-24');
INSERT INTO `sla_trend` VALUES ('116', '5', '08:45:00', '83.00', '37', '2025-11-24');
INSERT INTO `sla_trend` VALUES ('117', '5', '09:00:00', '87.00', '35', '2025-11-24');
INSERT INTO `sla_trend` VALUES ('118', '5', '09:15:00', '91.00', '29', '2025-11-24');
INSERT INTO `sla_trend` VALUES ('119', '5', '09:30:00', '81.00', '30', '2025-11-24');
INSERT INTO `sla_trend` VALUES ('120', '6', '08:00:00', '81.00', '25', '2025-11-24');
INSERT INTO `sla_trend` VALUES ('121', '6', '08:15:00', '90.00', '29', '2025-11-24');
INSERT INTO `sla_trend` VALUES ('122', '6', '08:30:00', '93.00', '20', '2025-11-24');
INSERT INTO `sla_trend` VALUES ('123', '6', '08:45:00', '88.00', '39', '2025-11-24');
INSERT INTO `sla_trend` VALUES ('124', '6', '09:00:00', '81.00', '38', '2025-11-24');
INSERT INTO `sla_trend` VALUES ('125', '6', '09:15:00', '87.00', '40', '2025-11-24');
INSERT INTO `sla_trend` VALUES ('126', '6', '09:30:00', '87.00', '33', '2025-11-24');
INSERT INTO `sla_trend` VALUES ('127', '1', '08:00:00', '93.00', '27', '2025-12-01');
INSERT INTO `sla_trend` VALUES ('128', '1', '08:15:00', '92.00', '39', '2025-12-01');
INSERT INTO `sla_trend` VALUES ('129', '1', '08:30:00', '86.00', '39', '2025-12-01');
INSERT INTO `sla_trend` VALUES ('130', '1', '08:45:00', '84.00', '36', '2025-12-01');
INSERT INTO `sla_trend` VALUES ('131', '1', '09:00:00', '85.00', '22', '2025-12-01');
INSERT INTO `sla_trend` VALUES ('132', '1', '09:15:00', '91.00', '20', '2025-12-01');
INSERT INTO `sla_trend` VALUES ('133', '1', '09:30:00', '81.00', '28', '2025-12-01');
INSERT INTO `sla_trend` VALUES ('134', '2', '08:00:00', '81.00', '39', '2025-12-01');
INSERT INTO `sla_trend` VALUES ('135', '2', '08:15:00', '87.00', '36', '2025-12-01');
INSERT INTO `sla_trend` VALUES ('136', '2', '08:30:00', '82.00', '24', '2025-12-01');
INSERT INTO `sla_trend` VALUES ('137', '2', '08:45:00', '92.00', '33', '2025-12-01');
INSERT INTO `sla_trend` VALUES ('138', '2', '09:00:00', '93.00', '21', '2025-12-01');
INSERT INTO `sla_trend` VALUES ('139', '2', '09:15:00', '94.00', '20', '2025-12-01');
INSERT INTO `sla_trend` VALUES ('140', '2', '09:30:00', '93.00', '24', '2025-12-01');
INSERT INTO `sla_trend` VALUES ('141', '3', '08:00:00', '83.00', '27', '2025-12-01');
INSERT INTO `sla_trend` VALUES ('142', '3', '08:15:00', '83.00', '37', '2025-12-01');
INSERT INTO `sla_trend` VALUES ('143', '3', '08:30:00', '87.00', '32', '2025-12-01');
INSERT INTO `sla_trend` VALUES ('144', '3', '08:45:00', '89.00', '35', '2025-12-01');
INSERT INTO `sla_trend` VALUES ('145', '3', '09:00:00', '80.00', '26', '2025-12-01');
INSERT INTO `sla_trend` VALUES ('146', '3', '09:15:00', '95.00', '21', '2025-12-01');
INSERT INTO `sla_trend` VALUES ('147', '3', '09:30:00', '93.00', '27', '2025-12-01');
INSERT INTO `sla_trend` VALUES ('148', '4', '08:00:00', '81.00', '32', '2025-12-01');
INSERT INTO `sla_trend` VALUES ('149', '4', '08:15:00', '81.00', '25', '2025-12-01');
INSERT INTO `sla_trend` VALUES ('150', '4', '08:30:00', '94.00', '30', '2025-12-01');
INSERT INTO `sla_trend` VALUES ('151', '4', '08:45:00', '92.00', '39', '2025-12-01');
INSERT INTO `sla_trend` VALUES ('152', '4', '09:00:00', '81.00', '30', '2025-12-01');
INSERT INTO `sla_trend` VALUES ('153', '4', '09:15:00', '82.00', '39', '2025-12-01');
INSERT INTO `sla_trend` VALUES ('154', '4', '09:30:00', '91.00', '37', '2025-12-01');
INSERT INTO `sla_trend` VALUES ('155', '5', '08:00:00', '81.00', '23', '2025-12-01');
INSERT INTO `sla_trend` VALUES ('156', '5', '08:15:00', '86.00', '23', '2025-12-01');
INSERT INTO `sla_trend` VALUES ('157', '5', '08:30:00', '94.00', '22', '2025-12-01');
INSERT INTO `sla_trend` VALUES ('158', '5', '08:45:00', '83.00', '37', '2025-12-01');
INSERT INTO `sla_trend` VALUES ('159', '5', '09:00:00', '87.00', '35', '2025-12-01');
INSERT INTO `sla_trend` VALUES ('160', '5', '09:15:00', '91.00', '29', '2025-12-01');
INSERT INTO `sla_trend` VALUES ('161', '5', '09:30:00', '81.00', '30', '2025-12-01');
INSERT INTO `sla_trend` VALUES ('162', '6', '08:00:00', '81.00', '25', '2025-12-01');
INSERT INTO `sla_trend` VALUES ('163', '6', '08:15:00', '90.00', '29', '2025-12-01');
INSERT INTO `sla_trend` VALUES ('164', '6', '08:30:00', '93.00', '20', '2025-12-01');
INSERT INTO `sla_trend` VALUES ('165', '6', '08:45:00', '88.00', '39', '2025-12-01');
INSERT INTO `sla_trend` VALUES ('166', '6', '09:00:00', '81.00', '38', '2025-12-01');
INSERT INTO `sla_trend` VALUES ('167', '6', '09:15:00', '87.00', '40', '2025-12-01');
INSERT INTO `sla_trend` VALUES ('168', '6', '09:30:00', '87.00', '33', '2025-12-01');
INSERT INTO `sla_trend` VALUES ('169', '1', '08:00:00', '93.00', '27', '2025-12-02');
INSERT INTO `sla_trend` VALUES ('170', '1', '08:15:00', '92.00', '39', '2025-12-02');
INSERT INTO `sla_trend` VALUES ('171', '1', '08:30:00', '86.00', '39', '2025-12-02');
INSERT INTO `sla_trend` VALUES ('172', '1', '08:45:00', '84.00', '36', '2025-12-02');
INSERT INTO `sla_trend` VALUES ('173', '1', '09:00:00', '85.00', '22', '2025-12-02');
INSERT INTO `sla_trend` VALUES ('174', '1', '09:15:00', '91.00', '20', '2025-12-02');
INSERT INTO `sla_trend` VALUES ('175', '1', '09:30:00', '81.00', '28', '2025-12-02');
INSERT INTO `sla_trend` VALUES ('176', '2', '08:00:00', '81.00', '39', '2025-12-02');
INSERT INTO `sla_trend` VALUES ('177', '2', '08:15:00', '87.00', '36', '2025-12-02');
INSERT INTO `sla_trend` VALUES ('178', '2', '08:30:00', '82.00', '24', '2025-12-02');
INSERT INTO `sla_trend` VALUES ('179', '2', '08:45:00', '92.00', '33', '2025-12-02');
INSERT INTO `sla_trend` VALUES ('180', '2', '09:00:00', '93.00', '21', '2025-12-02');
INSERT INTO `sla_trend` VALUES ('181', '2', '09:15:00', '94.00', '20', '2025-12-02');
INSERT INTO `sla_trend` VALUES ('182', '2', '09:30:00', '93.00', '24', '2025-12-02');
INSERT INTO `sla_trend` VALUES ('183', '3', '08:00:00', '83.00', '27', '2025-12-02');
INSERT INTO `sla_trend` VALUES ('184', '3', '08:15:00', '83.00', '37', '2025-12-02');
INSERT INTO `sla_trend` VALUES ('185', '3', '08:30:00', '87.00', '32', '2025-12-02');
INSERT INTO `sla_trend` VALUES ('186', '3', '08:45:00', '89.00', '35', '2025-12-02');
INSERT INTO `sla_trend` VALUES ('187', '3', '09:00:00', '80.00', '26', '2025-12-02');
INSERT INTO `sla_trend` VALUES ('188', '3', '09:15:00', '95.00', '21', '2025-12-02');
INSERT INTO `sla_trend` VALUES ('189', '3', '09:30:00', '93.00', '27', '2025-12-02');
INSERT INTO `sla_trend` VALUES ('190', '4', '08:00:00', '81.00', '32', '2025-12-02');
INSERT INTO `sla_trend` VALUES ('191', '4', '08:15:00', '81.00', '25', '2025-12-02');
INSERT INTO `sla_trend` VALUES ('192', '4', '08:30:00', '94.00', '30', '2025-12-02');
INSERT INTO `sla_trend` VALUES ('193', '4', '08:45:00', '92.00', '39', '2025-12-02');
INSERT INTO `sla_trend` VALUES ('194', '4', '09:00:00', '81.00', '30', '2025-12-02');
INSERT INTO `sla_trend` VALUES ('195', '4', '09:15:00', '82.00', '39', '2025-12-02');
INSERT INTO `sla_trend` VALUES ('196', '4', '09:30:00', '91.00', '37', '2025-12-02');
INSERT INTO `sla_trend` VALUES ('197', '5', '08:00:00', '81.00', '23', '2025-12-02');
INSERT INTO `sla_trend` VALUES ('198', '5', '08:15:00', '86.00', '23', '2025-12-02');
INSERT INTO `sla_trend` VALUES ('199', '5', '08:30:00', '94.00', '22', '2025-12-02');
INSERT INTO `sla_trend` VALUES ('200', '5', '08:45:00', '83.00', '37', '2025-12-02');
INSERT INTO `sla_trend` VALUES ('201', '5', '09:00:00', '87.00', '35', '2025-12-02');
INSERT INTO `sla_trend` VALUES ('202', '5', '09:15:00', '91.00', '29', '2025-12-02');
INSERT INTO `sla_trend` VALUES ('203', '5', '09:30:00', '81.00', '30', '2025-12-02');
INSERT INTO `sla_trend` VALUES ('204', '6', '08:00:00', '81.00', '25', '2025-12-02');
INSERT INTO `sla_trend` VALUES ('205', '6', '08:15:00', '90.00', '29', '2025-12-02');
INSERT INTO `sla_trend` VALUES ('206', '6', '08:30:00', '93.00', '20', '2025-12-02');
INSERT INTO `sla_trend` VALUES ('207', '6', '08:45:00', '88.00', '39', '2025-12-02');
INSERT INTO `sla_trend` VALUES ('208', '6', '09:00:00', '81.00', '38', '2025-12-02');
INSERT INTO `sla_trend` VALUES ('209', '6', '09:15:00', '87.00', '40', '2025-12-02');
INSERT INTO `sla_trend` VALUES ('210', '6', '09:30:00', '87.00', '33', '2025-12-02');
INSERT INTO `sla_trend` VALUES ('211', '1', '08:00:00', '93.00', '27', '2025-12-11');
INSERT INTO `sla_trend` VALUES ('212', '1', '08:15:00', '92.00', '39', '2025-12-11');
INSERT INTO `sla_trend` VALUES ('213', '1', '08:30:00', '86.00', '39', '2025-12-11');
INSERT INTO `sla_trend` VALUES ('214', '1', '08:45:00', '84.00', '36', '2025-12-11');
INSERT INTO `sla_trend` VALUES ('215', '1', '09:00:00', '85.00', '22', '2025-12-11');
INSERT INTO `sla_trend` VALUES ('216', '1', '09:15:00', '91.00', '20', '2025-12-11');
INSERT INTO `sla_trend` VALUES ('217', '1', '09:30:00', '81.00', '28', '2025-12-11');
INSERT INTO `sla_trend` VALUES ('218', '2', '08:00:00', '81.00', '39', '2025-12-11');
INSERT INTO `sla_trend` VALUES ('219', '2', '08:15:00', '87.00', '36', '2025-12-11');
INSERT INTO `sla_trend` VALUES ('220', '2', '08:30:00', '82.00', '24', '2025-12-11');
INSERT INTO `sla_trend` VALUES ('221', '2', '08:45:00', '92.00', '33', '2025-12-11');
INSERT INTO `sla_trend` VALUES ('222', '2', '09:00:00', '93.00', '21', '2025-12-11');
INSERT INTO `sla_trend` VALUES ('223', '2', '09:15:00', '94.00', '20', '2025-12-11');
INSERT INTO `sla_trend` VALUES ('224', '2', '09:30:00', '93.00', '24', '2025-12-11');
INSERT INTO `sla_trend` VALUES ('225', '3', '08:00:00', '83.00', '27', '2025-12-11');
INSERT INTO `sla_trend` VALUES ('226', '3', '08:15:00', '83.00', '37', '2025-12-11');
INSERT INTO `sla_trend` VALUES ('227', '3', '08:30:00', '87.00', '32', '2025-12-11');
INSERT INTO `sla_trend` VALUES ('228', '3', '08:45:00', '89.00', '35', '2025-12-11');
INSERT INTO `sla_trend` VALUES ('229', '3', '09:00:00', '80.00', '26', '2025-12-11');
INSERT INTO `sla_trend` VALUES ('230', '3', '09:15:00', '95.00', '21', '2025-12-11');
INSERT INTO `sla_trend` VALUES ('231', '3', '09:30:00', '93.00', '27', '2025-12-11');
INSERT INTO `sla_trend` VALUES ('232', '4', '08:00:00', '81.00', '32', '2025-12-11');
INSERT INTO `sla_trend` VALUES ('233', '4', '08:15:00', '81.00', '25', '2025-12-11');
INSERT INTO `sla_trend` VALUES ('234', '4', '08:30:00', '94.00', '30', '2025-12-11');
INSERT INTO `sla_trend` VALUES ('235', '4', '08:45:00', '92.00', '39', '2025-12-11');
INSERT INTO `sla_trend` VALUES ('236', '4', '09:00:00', '81.00', '30', '2025-12-11');
INSERT INTO `sla_trend` VALUES ('237', '4', '09:15:00', '82.00', '39', '2025-12-11');
INSERT INTO `sla_trend` VALUES ('238', '4', '09:30:00', '91.00', '37', '2025-12-11');
INSERT INTO `sla_trend` VALUES ('239', '5', '08:00:00', '81.00', '23', '2025-12-11');
INSERT INTO `sla_trend` VALUES ('240', '5', '08:15:00', '86.00', '23', '2025-12-11');
INSERT INTO `sla_trend` VALUES ('241', '5', '08:30:00', '94.00', '22', '2025-12-11');
INSERT INTO `sla_trend` VALUES ('242', '5', '08:45:00', '83.00', '37', '2025-12-11');
INSERT INTO `sla_trend` VALUES ('243', '5', '09:00:00', '87.00', '35', '2025-12-11');
INSERT INTO `sla_trend` VALUES ('244', '5', '09:15:00', '91.00', '29', '2025-12-11');
INSERT INTO `sla_trend` VALUES ('245', '5', '09:30:00', '81.00', '30', '2025-12-11');
INSERT INTO `sla_trend` VALUES ('246', '6', '08:00:00', '81.00', '25', '2025-12-11');
INSERT INTO `sla_trend` VALUES ('247', '6', '08:15:00', '90.00', '29', '2025-12-11');
INSERT INTO `sla_trend` VALUES ('248', '6', '08:30:00', '93.00', '20', '2025-12-11');
INSERT INTO `sla_trend` VALUES ('249', '6', '08:45:00', '88.00', '39', '2025-12-11');
INSERT INTO `sla_trend` VALUES ('250', '6', '09:00:00', '81.00', '38', '2025-12-11');
INSERT INTO `sla_trend` VALUES ('251', '6', '09:15:00', '87.00', '40', '2025-12-11');
INSERT INTO `sla_trend` VALUES ('252', '6', '09:30:00', '87.00', '33', '2025-12-11');
